/*
 * Decompiled with CFR 0.152.
 */
package java.lang.jtransc;

import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import j.ClassInfo;
import j.MemberInfo;
import j.ProgramReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class JTranscCoreReflection {
    public static <T> int[] getInterfaceIds(int classId) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.checkClassId(classId) ? ProgramReflection._classInfos[classId].interfaces : new int[]{};
    }

    private static boolean checkClassId(int classId) {
        ProgramReflection._ensure();
        return classId >= 0 && classId < ProgramReflection._classInfos.length;
    }

    public static <T> int getSuperclassId(int classId) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.checkClassId(classId) ? ProgramReflection._classInfos[classId].parent : -1;
    }

    public static Class<?> getSuperclassById(int classId) {
        return JTranscCoreReflection.getClassById(JTranscCoreReflection.getSuperclassId(classId));
    }

    public static <T> Constructor<T>[] getDeclaredConstructors(Class<?> clazz) {
        MemberInfo[] infos = ProgramReflection.getConstructors((int)JTranscCoreReflection.getClassId(clazz));
        int count = infos != null ? infos.length : 0;
        Constructor[] out = new Constructor[count];
        for (int n = 0; n < count; ++n) {
            out[n] = new Constructor(clazz, infos[n]);
        }
        return out;
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        MemberInfo[] infos = ProgramReflection.getMethods((int)JTranscCoreReflection.getClassId(clazz));
        int count = infos != null ? infos.length : 0;
        Method[] out = new Method[count];
        for (int n = 0; n < count; ++n) {
            out[n] = new Method(clazz, infos[n]);
        }
        return out;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        MemberInfo[] infos = ProgramReflection.getFields((int)JTranscCoreReflection.getClassId(clazz));
        int count = infos != null ? infos.length : 0;
        Field[] out = new Field[count];
        for (int n = 0; n < count; ++n) {
            out[n] = new Field(clazz, infos[n]);
        }
        return out;
    }

    public static int getClassId(Class<?> clazz) {
        return clazz.id;
    }

    private static int getClassIdByName(String name) {
        ProgramReflection._ensure();
        return ((ClassInfo)ProgramReflection._classInfosByName.get((String)name)).id;
    }

    public static String getClassNameById(int id) {
        if (!JTranscCoreReflection.checkClassId(id)) {
            return null;
        }
        ProgramReflection._ensure();
        return ProgramReflection._classInfos[id].name;
    }

    public static String[] getClassNames() {
        ProgramReflection._ensure();
        return ProgramReflection._classNames;
    }

    public static Class<?> getClassById(int id) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.getClassByName(JTranscCoreReflection.getClassNameById(id));
    }

    public static Class<?> getClassByName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static String getClassName(Class<?> clazz) {
        return clazz.getName();
    }

    public static boolean hasClassWithName(String name) {
        return ProgramReflection.hasClassWithName((String)name);
    }

    public static int getClassIdWithName(String name) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.hasClassWithName(name) ? ((ClassInfo)ProgramReflection._classInfosByName.get((String)name)).id : -1;
    }

    public static ClassInfo getClassInfoWithName(String name) {
        return ProgramReflection.getClassInfoWithName((String)name);
    }

    public static Annotation[] getDeclaredAnnotations(Class<?> clazz) {
        ProgramReflection._ensure();
        return ProgramReflection.getClassAnnotations((int)JTranscCoreReflection.getClassId(clazz));
    }

    @JTranscInline
    public static int getModifiersWithId(int classId) {
        ProgramReflection._ensure();
        return ProgramReflection._classInfos[classId].modifiers;
    }

    @HaxeMethodBody(value="return (p0 != null) ? Std.is(p0, JA_0) : false;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0 ? (p0 instanceof JA_0) : false;"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT(JA_0, p0) != nullptr;"}), @JTranscMethodBody(target="d", value={"return (cast(JA_0)p0) !is null;"}), @JTranscMethodBody(target="cs", value={"return p0 is JA_0;"}), @JTranscMethodBody(target="as3", value={"return p0 is JA_0;"}), @JTranscMethodBody(target="dart", value={"return p0 is JA_0;"}), @JTranscMethodBody(target="php", value={"return $p0 instanceof JA_0;"})})
    public static native boolean isArray(Object var0);

    @HaxeMethodBody(value="return (p0 != null) ? N.str(cast(p0, JA_0).desc) : null;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0 ? N.str(p0.desc) : null;"}), @JTranscMethodBody(target="cpp", value={"return N::str(GET_OBJECT(JA_0, p0)->desc);"}), @JTranscMethodBody(target="d", value={"return N.str((cast(JA_0)p0).desc);"}), @JTranscMethodBody(target="cs", value={"return N.str(((JA_0)p0).desc);"}), @JTranscMethodBody(target="as3", value={"return N.str((p0 as JA_0).desc);"}), @JTranscMethodBody(target="dart", value={"return N.str((p0 as JA_0).desc);"}), @JTranscMethodBody(target="php", value={"return N::str($p0->desc);"})})
    public static native String getArrayDescriptor(Object var0);

    @HaxeMethodBody(value="return p0._CLASS_ID__HX;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.$$CLASS_ID;"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE({% CLASS java.lang.Object %}, p0)->__INSTANCE_CLASS_ID;"}), @JTranscMethodBody(target="d", value={"return p0.__D__CLASS_ID;"}), @JTranscMethodBody(target="cs", value={"return p0.__CS__CLASS_ID;"}), @JTranscMethodBody(target="as3", value={"return p0.__AS3__CLASS_ID;"}), @JTranscMethodBody(target="dart", value={"return p0.__DART__CLASS_ID;"}), @JTranscMethodBody(target="php", value={"return $p0->__DART__CLASS_ID;"})})
    public static int getClassId(Object obj) {
        return -1;
    }
}

