/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.io.JTranscConsole;
import com.jtransc.text.MStringReader;
import java.lang.reflect.ArrayType;
import java.lang.reflect.MethodTypeImpl;
import java.lang.reflect.ParameterizedTypeImpl;
import java.lang.reflect.Type;
import java.util.ArrayList;

@JTranscInvisible
class _InternalUtils {
    _InternalUtils() {
    }

    static Class<?> Class_forName0(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            JTranscConsole.error((Object)("Class_forName0: Can't find class '" + className + "'"));
            return null;
        }
    }

    static MethodTypeImpl parseMethodType(String str, Type owner) {
        return (MethodTypeImpl)_InternalUtils.parseType(new MStringReader(str), owner);
    }

    static Type parseType(String str, Type owner) {
        return _InternalUtils.parseType(new MStringReader(str), owner);
    }

    static Type parseType(MStringReader sr, Type owner) {
        char c = sr.read();
        switch (c) {
            case '(': {
                Type[] args = _InternalUtils.parseTypes(sr, owner);
                sr.expect(')');
                Type retval = _InternalUtils.parseType(sr, owner);
                return new MethodTypeImpl(args, retval);
            }
            case '+': {
                return _InternalUtils.parseType(sr, owner);
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case '[': {
                int start = sr.offset - 1;
                Type type = _InternalUtils.parseType(sr, owner);
                int end = sr.offset;
                if (type instanceof Class) {
                    return _InternalUtils.Class_forName0(sr.str.substring(start, end));
                }
                return new ArrayType(type);
            }
            case 'L': 
            case 'T': {
                Type base;
                boolean generic = c == 'T';
                String fqname = sr.readUntil(';', '<', false).replace('/', '.');
                Class<?> clazz = base = generic ? _InternalUtils.Class_forName0("java.lang.Object") : _InternalUtils.Class_forName0(fqname);
                if (sr.peek() == '<') {
                    base = _InternalUtils.parseTypeGeneric(base, sr, owner);
                }
                sr.expect(';');
                return base;
            }
        }
        throw new Error("Can't parse type '" + c + "' of " + sr.str);
    }

    static Type parseTypeGeneric(Type base, MStringReader sr, Type owner) {
        sr.expect('<');
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        while (sr.hasMore() && sr.peek() != '>') {
            paramTypes.add(_InternalUtils.parseType(sr, owner));
        }
        sr.expect('>');
        return new ParameterizedTypeImpl(paramTypes.toArray(new Type[paramTypes.size()]), base, owner);
    }

    static Type[] parseTypes(String str, Type owner) {
        return _InternalUtils.parseTypes(new MStringReader(str, 0), owner);
    }

    static Type[] parseTypes(MStringReader sr, Type owner) {
        ArrayList<Type> types = new ArrayList<Type>();
        while (sr.hasMore() && sr.peek() != ')') {
            types.add(_InternalUtils.parseType(sr, owner));
        }
        return types.toArray(new Type[types.size()]);
    }

    static String getTypeName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }
}

