/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import com.jtransc.annotation.JTranscMethodBody;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.CompletionHandler;
import java.nio.channels.NetworkChannel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AsynchronousSocketChannel
implements AsynchronousByteChannel,
NetworkChannel {
    protected AsynchronousSocketChannel(AsynchronousChannelProvider provider) {
    }

    public final AsynchronousChannelProvider provider() {
        return null;
    }

    public static AsynchronousSocketChannel open(AsynchronousChannelGroup group) throws IOException {
        return new AsynchronousSocketChannel();
    }

    public static AsynchronousSocketChannel open() throws IOException {
        return AsynchronousSocketChannel.open(null);
    }

    AsynchronousSocketChannel() {
    }

    @Override
    public native AsynchronousSocketChannel bind(SocketAddress var1) throws IOException;

    @Override
    public native <T> AsynchronousSocketChannel setOption(SocketOption<T> var1, T var2) throws IOException;

    @Override
    public native <T> T getOption(SocketOption<T> var1) throws IOException;

    @Override
    public native Set<SocketOption<?>> supportedOptions();

    public native AsynchronousSocketChannel shutdownInput() throws IOException;

    public native AsynchronousSocketChannel shutdownOutput() throws IOException;

    public native SocketAddress getRemoteAddress() throws IOException;

    @JTranscMethodBody(target="js", value={"var address = N.istr(p0), port = p1, attachment = p2, handler = p3;", "var net = require('net');", "this.client = new net.Socket();", "this.client.on('error', function() {", "\thandler{% IMETHOD java.nio.channels.CompletionHandler:failed %}(N.createRuntimeException('error'), attachment);", "});", "this.client.connect(port, address, function() {", "\thandler{% IMETHOD java.nio.channels.CompletionHandler:completed %}(null, attachment);", "});"})
    private native <A> void _connect(String var1, int var2, A var3, CompletionHandler<Void, ? super A> var4);

    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        InetSocketAddress address = (InetSocketAddress)remote;
        this._connect(address.getHostName(), address.getPort(), attachment, handler);
    }

    public native Future<Void> connect(SocketAddress var1);

    @Override
    public final <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.read(dst, 0L, TimeUnit.MILLISECONDS, attachment, handler);
    }

    @Override
    public native Future<Integer> read(ByteBuffer var1);

    private native <A> void _read(byte[] var1, int var2, int var3, double var4, A var6, CompletionHandler<Integer, ? super A> var7);

    @JTranscMethodBody(target="js", value={"var data = p0.data, offset = p1, len = p2, timeout = p3, attachment = p4, handler = p5;", "this.client.write(new Buffer(new Int8Array(data.buffer, offset, len)), function() {", "\thandler{% IMETHOD java.nio.channels.CompletionHandler:completed %}(N.boxInt(len), attachment);", "});"})
    private native <A> void _write(byte[] var1, int var2, int var3, double var4, A var6, CompletionHandler<Integer, ? super A> var7);

    public native <A> void read(ByteBuffer[] var1, int var2, int var3, long var4, TimeUnit var6, A var7, CompletionHandler<Long, ? super A> var8);

    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this._read(dst.array(), dst.arrayOffset(), dst.limit(), unit.toMillis(timeout), attachment, handler);
    }

    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this._write(src.array(), src.arrayOffset(), src.limit(), unit.toMillis(timeout), attachment, handler);
    }

    @Override
    public final <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.write(src, 0L, TimeUnit.MILLISECONDS, attachment, handler);
    }

    @Override
    public native Future<Integer> write(ByteBuffer var1);

    public native <A> void write(ByteBuffer[] var1, int var2, int var3, long var4, TimeUnit var6, A var7, CompletionHandler<Long, ? super A> var8);

    @Override
    public native SocketAddress getLocalAddress() throws IOException;

    @Override
    public native boolean isOpen();

    @Override
    @JTranscMethodBody(target="js", value={"this.client.end()"})
    public native void close() throws IOException;
}

