/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.IOException;

public class FileSystemException
extends IOException {
    private final String file;
    private final String other;

    public FileSystemException(String file) {
        super((String)null);
        this.file = file;
        this.other = null;
    }

    public FileSystemException(String file, String other, String reason) {
        super(reason);
        this.file = file;
        this.other = other;
    }

    public String getFile() {
        return this.file;
    }

    public String getOtherFile() {
        return this.other;
    }

    public String getReason() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String out = "";
        if (this.file != null) {
            out = out + this.file;
        }
        if (this.other != null) {
            out = out + " -> ";
            out = out + this.other;
        }
        if (this.getReason() != null) {
            if (!out.isEmpty()) {
                out = out + ": ";
            }
            out = out + this.getReason();
        }
        return out;
    }
}

