/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

public enum TimeUnit {
    NANOSECONDS(1L),
    MICROSECONDS(1000L),
    MILLISECONDS(1000000L),
    SECONDS(1000000000L),
    MINUTES(60000000000L),
    HOURS(3600000000000L),
    DAYS(86400000000000L);

    private long value;

    private TimeUnit(long value) {
        this.value = value;
    }

    public long convert(long duration, TimeUnit sourceUnit) {
        return this._convert(duration, sourceUnit.value);
    }

    private long _convert(long duration, long constant) {
        return duration * this.value / constant;
    }

    public long toNanos(long duration) {
        return this._convert(duration, 1L);
    }

    public long toMicros(long duration) {
        return this._convert(duration, 1000L);
    }

    public long toMillis(long duration) {
        return this._convert(duration, 1000000L);
    }

    public long toSeconds(long duration) {
        return this._convert(duration, 1000000000L);
    }

    public long toMinutes(long duration) {
        return this._convert(duration, 60000000000L);
    }

    public long toHours(long duration) {
        return this._convert(duration, 3600000000000L);
    }

    public long toDays(long duration) {
        return this._convert(duration, 86400000000000L);
    }

    int excessNanos(long d, long m) {
        return 0;
    }

    public void timedWait(Object obj, long timeout) {
    }

    public void timedJoin(Thread thread, long timeout) throws InterruptedException {
    }

    public void sleep(long timeout) throws InterruptedException {
    }

    private static class CST {
        private static final long NANO = 1L;
        private static final long MICRO = 1000L;
        private static final long MILLIS = 1000000L;
        private static final long SECOND = 1000000000L;
        private static final long MINUTE = 60000000000L;
        private static final long HOURS = 3600000000000L;
        private static final long DAYS = 86400000000000L;

        private CST() {
        }
    }
}

