/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class IntegerTools {
    IntegerTools() {
    }

    public static int countDigits(int i, int radix) {
        if (radix == 10) {
            return IntegerTools.countDigits10(i);
        }
        if (radix == 16) {
            return IntegerTools.countDigits16(i);
        }
        if (radix == 2) {
            return IntegerTools.countDigits2(i);
        }
        return IntegerTools.countDigitsGeneric(i, radix);
    }

    public static int countDigitsGeneric(int i, int radix) {
        boolean negative = i < 0;
        int count = 0;
        if (negative) {
            i = -i;
            ++count;
        }
        if (i == 0) {
            ++count;
        } else {
            while (i != 0) {
                ++count;
                i = Integer.divideUnsigned(i, radix);
            }
        }
        return count;
    }

    private static int countDigits2(int n) {
        if (n < 0) {
            return n == Integer.MIN_VALUE ? 33 : 1 + IntegerTools.countDigits2(-n);
        }
        return 32 - Integer.numberOfLeadingZeros(n);
    }

    private static int countDigits16(int n) {
        if (n < 0) {
            return n == Integer.MIN_VALUE ? 9 : 1 + IntegerTools.countDigits16(-n);
        }
        if (n < 16) {
            return 1;
        }
        if (n < 256) {
            return 2;
        }
        if (n < 4096) {
            return 3;
        }
        if (n < 65536) {
            return 4;
        }
        if (n < 0x100000) {
            return 5;
        }
        if (n < 0x1000000) {
            return 6;
        }
        if (n < 0x10000000) {
            return 7;
        }
        return 8;
    }

    private static int countDigits10(int x) {
        if (x < 0) {
            return x == Integer.MIN_VALUE ? 11 : 1 + IntegerTools.countDigits10(-x);
        }
        if (x < 10) {
            return 1;
        }
        if (x < 100) {
            return 2;
        }
        if (x < 1000) {
            return 3;
        }
        if (x < 10000) {
            return 4;
        }
        if (x < 100000) {
            return 5;
        }
        if (x < 1000000) {
            return 6;
        }
        if (x < 10000000) {
            return 7;
        }
        if (x < 100000000) {
            return 8;
        }
        if (x < 1000000000) {
            return 9;
        }
        return 10;
    }

    public static int writeInt(char[] out, int offset, int i, int radix) {
        if (radix < 2) {
            throw new RuntimeException("Invalid radix");
        }
        if (i == Integer.MIN_VALUE) {
            int count = IntegerTools.countDigits(i, radix);
            int o = offset + count;
            while (i != 0) {
                out[--o] = Character.forDigit(Integer.remainderUnsigned(i, radix), radix);
                i = Integer.divideUnsigned(i, radix);
            }
            out[--o] = 45;
            return count;
        }
        boolean negative = i < 0;
        int count = IntegerTools.countDigits(i, radix);
        if (negative) {
            i = -i;
        }
        int o = offset + count;
        if (i == 0) {
            out[--o] = 48;
        } else if (radix == 10) {
            while (i != 0) {
                int v = i % 10;
                i /= 10;
                out[--o] = Character.forDigit(v, radix);
            }
        } else {
            while (i != 0) {
                int v = i % radix;
                i /= radix;
                out[--o] = Character.forDigit(v, radix);
            }
        }
        if (negative) {
            out[--o] = 45;
        }
        return count;
    }
}

