/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.jtransc.JTranscBits;
import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscAddMembersList;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.internal.ByteBufferAs;
import libcore.io.Memory;

@HaxeAddMembers(value={"public var tarray:haxe.io.Float64Array = null;"})
@JTranscAddMembersList(value={@JTranscAddMembers(target="dart", value={"Float64List tarray;"}), @JTranscAddMembers(target="cpp", value={"float64_t* tarray = nullptr;"}), @JTranscAddMembers(target="cs", value={"public byte[] tarray;"})})
abstract class ByteBufferAsDoubleBuffer
extends DoubleBuffer
implements ByteBufferAs {
    final ByteBuffer byteBuffer;
    final byte[] bytes;

    static DoubleBuffer asDoubleBuffer(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.order(byteBuffer.order());
        return ByteBufferAsDoubleBuffer.create(slice, byteBuffer.isLittleEndian);
    }

    private static ByteBufferAsDoubleBuffer create(ByteBuffer byteBuffer, boolean isLittleEndian) {
        return isLittleEndian ? new LE(byteBuffer) : new BE(byteBuffer);
    }

    private ByteBufferAsDoubleBuffer createWithSameOrder(ByteBuffer byteBuffer) {
        return ByteBufferAsDoubleBuffer.create(byteBuffer, this.order() == ByteOrder.LITTLE_ENDIAN);
    }

    private ByteBufferAsDoubleBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() / 8);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.bytes = byteBuffer.array();
        this.init(byteBuffer.array());
    }

    @HaxeMethodBody(value="this.tarray = haxe.io.Float64Array.fromBytes(p0.data);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.tarray = new Float64Array(p0.data.buffer);"}), @JTranscMethodBody(target="dart", value={"this.tarray = new Float64List.view(p0.data.buffer);"}), @JTranscMethodBody(target="cpp", value={"this->tarray = (float64_t *)(GET_OBJECT(JA_B, p0)->_data);"}), @JTranscMethodBody(target="cs", value={"unchecked { this.tarray = (byte[])(Array)p0.data; }"})})
    private void init(byte[] data) {
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        ByteBufferAsDoubleBuffer buf = (ByteBufferAsDoubleBuffer)this.byteBuffer.asReadOnlyBuffer().asDoubleBuffer();
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        buf.byteBuffer.order = this.byteBuffer.order;
        return buf;
    }

    @Override
    public DoubleBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit * 8);
        this.byteBuffer.position(this.position * 8);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public DoubleBuffer duplicate() {
        ByteBuffer bb = this.byteBuffer.duplicate().order(this.byteBuffer.order());
        ByteBufferAsDoubleBuffer buf = this.createWithSameOrder(bb);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public double get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getDouble(this.position++ * 8);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    double[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean protectedHasArray() {
        return false;
    }

    @Override
    public DoubleBuffer put(double c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putDouble(this.position++ * 8, c);
        return this;
    }

    @Override
    public DoubleBuffer slice() {
        this.byteBuffer.limit(this.limit * 8);
        this.byteBuffer.position(this.position * 8);
        ByteBuffer bb = this.byteBuffer.slice().order(this.byteBuffer.order());
        ByteBufferAsDoubleBuffer result = this.createWithSameOrder(bb);
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    @HaxeMethodBody(value="return this.tarray.get(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this.tarray[p0];"}), @JTranscMethodBody(target="dart", value={"return this.tarray[p0];"}), @JTranscMethodBody(target="cpp", value={"return this->tarray[p0];"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { return ((double *)ptr)[p0]; } }"})})
    public double get(int index) {
        return Memory.peekAlignedDoubleLE(this.bytes, index);
    }

    @Override
    @HaxeMethodBody(value="this.tarray.set(p0, p1); return this;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="dart", value={"this.tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cpp", value={"this->tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { ((double *)ptr)[p0] = p1; } } return this;"})})
    public DoubleBuffer put(int index, double c) {
        Memory.pokeAlignedDoubleLE(this.bytes, index, c);
        return this;
    }

    public long getLong(int index) {
        return Memory.peekAlignedLongLE(this.bytes, index);
    }

    public DoubleBuffer putLong(int index, long c) {
        Memory.pokeAlignedLongLE(this.bytes, index, c);
        return this;
    }

    public static final class BE
    extends ByteBufferAsDoubleBuffer {
        BE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        public double get(int index) {
            return Double.longBitsToDouble(Long.reverseBytes(this.getLong(index)));
        }

        @Override
        public DoubleBuffer put(int index, double c) {
            return this.putLong(index, JTranscBits.reverseBytes((long)Double.doubleToRawLongBits(c)));
        }
    }

    public static final class LE
    extends ByteBufferAsDoubleBuffer {
        LE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }
    }
}

