/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscAddMembersList;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.internal.ByteBufferAs;
import libcore.io.Memory;

@HaxeAddMembers(value={"public var tarray:haxe.io.Int32Array = null;"})
@JTranscAddMembersList(value={@JTranscAddMembers(target="dart", value={"Int32List tarray;"}), @JTranscAddMembers(target="cpp", value={"int32_t* tarray = nullptr;"}), @JTranscAddMembers(target="cs", value={"public byte[] tarray;"})})
abstract class ByteBufferAsIntBuffer
extends IntBuffer
implements ByteBufferAs {
    final ByteBuffer byteBuffer;
    final byte[] bytes;

    static IntBuffer asIntBuffer(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.order(byteBuffer.order());
        return ByteBufferAsIntBuffer.create(slice, byteBuffer.isLittleEndian);
    }

    private static ByteBufferAsIntBuffer create(ByteBuffer byteBuffer, boolean isLittleEndian) {
        return isLittleEndian ? new LE(byteBuffer) : new BE(byteBuffer);
    }

    private ByteBufferAsIntBuffer createWithSameOrder(ByteBuffer byteBuffer) {
        return ByteBufferAsIntBuffer.create(byteBuffer, this.order() == ByteOrder.LITTLE_ENDIAN);
    }

    ByteBufferAsIntBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() / 4);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.bytes = byteBuffer.array();
        this.init(byteBuffer.array());
    }

    @HaxeMethodBody(value="this.tarray = haxe.io.Int32Array.fromBytes(p0.data);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.tarray = new Int32Array(p0.data.buffer);"}), @JTranscMethodBody(target="dart", value={"this.tarray = new Int32List.view(p0.data.buffer);"}), @JTranscMethodBody(target="cpp", value={"this->tarray = (int32_t *)(GET_OBJECT(JA_B, p0)->_data);"}), @JTranscMethodBody(target="cs", value={"unchecked { this.tarray = p0.u(); }"})})
    private void init(byte[] data) {
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        ByteBufferAsIntBuffer buf = (ByteBufferAsIntBuffer)this.byteBuffer.asReadOnlyBuffer().asIntBuffer();
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        buf.byteBuffer.order = this.byteBuffer.order;
        return buf;
    }

    @Override
    public IntBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit * 4);
        this.byteBuffer.position(this.position * 4);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public IntBuffer duplicate() {
        ByteBuffer bb = this.byteBuffer.duplicate().order(this.byteBuffer.order());
        ByteBufferAsIntBuffer buf = this.createWithSameOrder(bb);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public int get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.get(this.position++);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    int[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean protectedHasArray() {
        return false;
    }

    @Override
    public IntBuffer put(int c) {
        return this.put(this.position++, c);
    }

    @Override
    public IntBuffer slice() {
        this.byteBuffer.limit(this.limit * 4);
        this.byteBuffer.position(this.position * 4);
        ByteBuffer bb = this.byteBuffer.slice().order(this.byteBuffer.order());
        ByteBufferAsIntBuffer result = this.createWithSameOrder(bb);
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    @HaxeMethodBody(value="return this.tarray.get(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this.tarray[p0];"}), @JTranscMethodBody(target="dart", value={"return this.tarray[p0];"}), @JTranscMethodBody(target="cpp", value={"return this->tarray[p0];"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { return ((int *)ptr)[p0]; } }"})})
    public int get(int index) {
        this.checkIndex(index);
        return Memory.peekAlignedIntLE(this.bytes, index);
    }

    @Override
    @HaxeMethodBody(value="this.tarray.set(p0, p1); return this;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="dart", value={"this.tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cpp", value={"this->tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { ((int *)ptr)[p0] = p1;; } } return this;"})})
    public IntBuffer put(int index, int c) {
        this.checkIndex(index);
        Memory.pokeAlignedIntLE(this.bytes, index, c);
        return this;
    }

    public static final class BE
    extends ByteBufferAsIntBuffer {
        BE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        public int get(int index) {
            return Memory.peekAlignedIntBE(this.bytes, index);
        }

        @Override
        public IntBuffer put(int index, int c) {
            this.checkIndex(index);
            Memory.pokeAlignedInt(this.bytes, index, c, false);
            return this;
        }
    }

    public static final class LE
    extends ByteBufferAsIntBuffer {
        LE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }
    }
}

