/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ImmediateFuture;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadPoolExecutor
implements ExecutorService {
    private static final int TASK_WAITING = 1;
    private static final int TASK_RUNNING = 2;
    private static final int TASK_STOPPING = 3;
    private static final int EX_WORKING = 1;
    private static final int EX_STOP = 2;
    private static final int EX_SHUTDOWN = 3;
    private static final int MAX_POOL_SIZE = 0x3FFFFFFF;
    private int state = 1;
    private int poolSize;
    private int maxPoolSize;
    private final BlockingQueue<Runnable> workQueue;
    private ThreadFactory factory;
    private RejectedExecutionHandler rejectHandler;
    private ArrayList<Task> taskPool;

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, null, null);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, null);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, null, handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize) {
            throw new IllegalArgumentException();
        }
        this.poolSize = corePoolSize;
        this.maxPoolSize = Math.min(maximumPoolSize, 0x3FFFFFFF);
        this.workQueue = workQueue == null ? new LinkedBlockingDeque() : workQueue;
        this.factory = threadFactory == null ? new Executors.DefaultThreadFactory() : threadFactory;
        this.rejectHandler = handler;
        this.taskPool = new ArrayList();
        for (int i = 0; i < this.poolSize; ++i) {
            this.taskPool.add(new Task());
        }
    }

    @Override
    public void shutdown() {
        this.state = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        ArrayList<Runnable> l;
        this.state = 3;
        for (Task t : this.taskPool) {
            if (t.state != 2) continue;
            t.state = 3;
        }
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        synchronized (blockingQueue) {
            l = new ArrayList<Runnable>(this.workQueue);
            this.workQueue.clear();
        }
        return l;
    }

    @Override
    public boolean isShutdown() {
        return this.state == 3;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            return new ImmediateFuture<T>(task.call());
        }
        catch (Exception e) {
            return new ImmediateFuture<Object>(null);
        }
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        task.run();
        return new ImmediateFuture<T>(result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> out = new ArrayList<Future<T>>();
        for (Callable<T> task : tasks) {
            try {
                out.add(new ImmediateFuture<T>(task.call()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.invokeAll(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        for (Callable<T> task : tasks) {
            try {
                return task.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeAny(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        if (this.state != 1) {
            if (this.rejectHandler != null) {
                this.rejectHandler.rejectedExecution(command, this);
            }
            return;
        }
        BlockingQueue<Runnable> blockingQueue = this.workQueue;
        synchronized (blockingQueue) {
            try {
                this.workQueue.put(command);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.execute();
    }

    private void execute() {
        for (Task t : this.taskPool) {
            if (t.state != 1) continue;
            this.factory.newThread(t).start();
            return;
        }
        if (this.poolSize < this.maxPoolSize) {
            ++this.poolSize;
            this.taskPool.add(new Task());
            this.execute();
        }
    }

    private class Task
    implements Runnable {
        public int state = 1;

        private Task() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.state = 2;
            while (this.state < 3) {
                Runnable command;
                BlockingQueue blockingQueue = ThreadPoolExecutor.this.workQueue;
                synchronized (blockingQueue) {
                    command = (Runnable)ThreadPoolExecutor.this.workQueue.poll();
                }
                if (command != null) {
                    command.run();
                    continue;
                }
                this.state = 3;
            }
            this.state = 1;
        }
    }
}

