/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import com.jtransc.JTranscBits;
import java.nio.ByteOrder;

public class Memory {
    private static ByteOrder NATIVE = ByteOrder.nativeOrder();
    private static ByteOrder SWAPPED = NATIVE == ByteOrder.LITTLE_ENDIAN ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;

    public static char peekAlignedCharLE(byte[] src, int offset) {
        return Memory.peekCharLE(src, offset * 2);
    }

    public static short peekAlignedShortLE(byte[] src, int offset) {
        return Memory.peekShortLE(src, offset * 2);
    }

    public static int peekAlignedIntLE(byte[] src, int offset) {
        return Memory.peekIntLE(src, offset * 4);
    }

    public static long peekAlignedLongLE(byte[] src, int offset) {
        return Memory.peekLongLE(src, offset * 8);
    }

    public static float peekAlignedFloatLE(byte[] src, int offset) {
        return Memory.peekFloatLE(src, offset * 4);
    }

    public static double peekAlignedDoubleLE(byte[] src, int offset) {
        return Memory.peekDoubleLE(src, offset * 8);
    }

    public static char peekAlignedCharBE(byte[] src, int offset) {
        return Character.reverseBytes(Memory.peekAlignedCharLE(src, offset));
    }

    public static short peekAlignedShortBE(byte[] src, int offset) {
        return Short.reverseBytes(Memory.peekAlignedShortLE(src, offset));
    }

    public static int peekAlignedIntBE(byte[] src, int offset) {
        return Integer.reverseBytes(Memory.peekAlignedIntLE(src, offset));
    }

    public static long peekAlignedLongBE(byte[] src, int offset) {
        return Long.reverseBytes(Memory.peekAlignedLongLE(src, offset));
    }

    public static float peekAlignedFloatBE(byte[] src, int offset) {
        return Float.intBitsToFloat(Memory.peekAlignedIntBE(src, offset));
    }

    public static double peekAlignedDoubleBE(byte[] src, int offset) {
        return Double.longBitsToDouble(Memory.peekAlignedLongBE(src, offset));
    }

    public static char peekCharLE(byte[] src, int offset) {
        return (char)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static short peekShortLE(byte[] src, int offset) {
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static int peekIntLE(byte[] src, int offset) {
        return (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
    }

    public static long peekLongLE(byte[] src, int offset) {
        int l = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 24;
        int h = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static float peekFloatLE(byte[] src, int offset) {
        return Float.intBitsToFloat(Memory.peekIntLE(src, offset));
    }

    public static double peekDoubleLE(byte[] src, int offset) {
        return Double.longBitsToDouble(Memory.peekLongLE(src, offset));
    }

    public static short peekShortBE(byte[] src, int offset) {
        return Short.reverseBytes(Memory.peekShortLE(src, offset));
    }

    public static int peekIntBE(byte[] src, int offset) {
        return Integer.reverseBytes(Memory.peekIntLE(src, offset));
    }

    public static long peekLongBE(byte[] src, int offset) {
        return Long.reverseBytes(Memory.peekLongLE(src, offset));
    }

    public static float peekFloatBE(byte[] src, int offset) {
        return Float.intBitsToFloat(Memory.peekIntBE(src, offset));
    }

    public static double peekDoubleBE(byte[] src, int offset) {
        return Double.longBitsToDouble(Memory.peekLongBE(src, offset));
    }

    public static short peekShort(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekShortLE(src, offset);
        }
        return Memory.peekShortBE(src, offset);
    }

    public static int peekInt(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekIntLE(src, offset);
        }
        return Memory.peekIntBE(src, offset);
    }

    public static long peekLong(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekLongLE(src, offset);
        }
        return Memory.peekLongBE(src, offset);
    }

    public static float peekFloat(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekFloatLE(src, offset);
        }
        return Memory.peekFloatBE(src, offset);
    }

    public static double peekDouble(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekDoubleLE(src, offset);
        }
        return Memory.peekDoubleBE(src, offset);
    }

    public static char peekAlignedChar(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekAlignedCharLE(src, offset);
        }
        return Memory.peekAlignedCharBE(src, offset);
    }

    public static short peekAlignedShort(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekAlignedShortLE(src, offset);
        }
        return Memory.peekAlignedShortBE(src, offset);
    }

    public static int peekAlignedInt(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekAlignedIntLE(src, offset);
        }
        return Memory.peekAlignedIntBE(src, offset);
    }

    public static long peekAlignedLong(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekAlignedLongLE(src, offset);
        }
        return Memory.peekAlignedLongBE(src, offset);
    }

    public static float peekAlignedFloat(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekAlignedFloatLE(src, offset);
        }
        return Memory.peekAlignedFloatBE(src, offset);
    }

    public static double peekAlignedDouble(byte[] src, int offset, boolean isLittleEndian) {
        if (isLittleEndian) {
            return Memory.peekAlignedDoubleLE(src, offset);
        }
        return Memory.peekAlignedDoubleBE(src, offset);
    }

    public static void pokeShort(byte[] dst, int offset, short value, boolean isLittleEndian) {
        JTranscBits.writeShort((byte[])dst, (int)offset, (short)value, (boolean)isLittleEndian);
    }

    public static void pokeChar(byte[] dst, int offset, char value, boolean isLittleEndian) {
        JTranscBits.writeChar((byte[])dst, (int)offset, (char)value, (boolean)isLittleEndian);
    }

    public static void pokeInt(byte[] dst, int offset, int value, boolean isLittleEndian) {
        JTranscBits.writeInt((byte[])dst, (int)offset, (int)value, (boolean)isLittleEndian);
    }

    public static void pokeLong(byte[] dst, int offset, long value, boolean isLittleEndian) {
        JTranscBits.writeLong((byte[])dst, (int)offset, (long)value, (boolean)isLittleEndian);
    }

    public static void pokeFloat(byte[] dst, int offset, float value, boolean isLittleEndian) {
        JTranscBits.writeFloat((byte[])dst, (int)offset, (float)value, (boolean)isLittleEndian);
    }

    public static void pokeDouble(byte[] dst, int offset, double value, boolean isLittleEndian) {
        JTranscBits.writeDouble((byte[])dst, (int)offset, (double)value, (boolean)isLittleEndian);
    }

    public static void pokeAlignedShort(byte[] dst, int offset, short value, boolean isLittleEndian) {
        JTranscBits.writeShort((byte[])dst, (int)(offset * 2), (short)value, (boolean)isLittleEndian);
    }

    public static void pokeAlignedChar(byte[] dst, int offset, char value, boolean isLittleEndian) {
        JTranscBits.writeChar((byte[])dst, (int)(offset * 2), (char)value, (boolean)isLittleEndian);
    }

    public static void pokeAlignedInt(byte[] dst, int offset, int value, boolean isLittleEndian) {
        JTranscBits.writeInt((byte[])dst, (int)(offset * 4), (int)value, (boolean)isLittleEndian);
    }

    public static void pokeAlignedLong(byte[] dst, int offset, long value, boolean isLittleEndian) {
        JTranscBits.writeLong((byte[])dst, (int)(offset * 8), (long)value, (boolean)isLittleEndian);
    }

    public static void pokeAlignedFloat(byte[] dst, int offset, float value, boolean isLittleEndian) {
        JTranscBits.writeFloat((byte[])dst, (int)(offset * 4), (float)value, (boolean)isLittleEndian);
    }

    public static void pokeAlignedDouble(byte[] dst, int offset, double value, boolean isLittleEndian) {
        JTranscBits.writeDouble((byte[])dst, (int)(offset * 8), (double)value, (boolean)isLittleEndian);
    }

    public static void pokeAlignedShortLE(byte[] dst, int offset, short value) {
        JTranscBits.writeShortLE((byte[])dst, (int)(offset * 2), (short)value);
    }

    public static void pokeAlignedCharLE(byte[] dst, int offset, char value) {
        JTranscBits.writeCharLE((byte[])dst, (int)(offset * 2), (char)value);
    }

    public static void pokeAlignedIntLE(byte[] dst, int offset, int value) {
        JTranscBits.writeIntLE((byte[])dst, (int)(offset * 4), (int)value);
    }

    public static void pokeAlignedLongLE(byte[] dst, int offset, long value) {
        JTranscBits.writeLongLE((byte[])dst, (int)(offset * 8), (long)value);
    }

    public static void pokeAlignedFloatLE(byte[] dst, int offset, float value) {
        JTranscBits.writeFloatLE((byte[])dst, (int)(offset * 4), (float)value);
    }

    public static void pokeAlignedDoubleLE(byte[] dst, int offset, double value) {
        JTranscBits.writeDoubleLE((byte[])dst, (int)(offset * 8), (double)value);
    }

    public static void pokeAlignedShortBE(byte[] dst, int offset, short value) {
        JTranscBits.writeShortBE((byte[])dst, (int)(offset * 2), (short)value);
    }

    public static void pokeAlignedCharBE(byte[] dst, int offset, char value) {
        JTranscBits.writeCharBE((byte[])dst, (int)(offset * 2), (char)value);
    }

    public static void pokeAlignedIntBE(byte[] dst, int offset, int value) {
        JTranscBits.writeIntBE((byte[])dst, (int)(offset * 4), (int)value);
    }

    public static void pokeAlignedLongBE(byte[] dst, int offset, long value) {
        JTranscBits.writeLongBE((byte[])dst, (int)(offset * 8), (long)value);
    }

    public static void pokeAlignedFloatBE(byte[] dst, int offset, float value) {
        JTranscBits.writeFloatBE((byte[])dst, (int)(offset * 4), (float)value);
    }

    public static void pokeAlignedDoubleBE(byte[] dst, int offset, double value) {
        JTranscBits.writeDoubleBE((byte[])dst, (int)(offset * 8), (double)value);
    }

    public static void unsafeBulkGet(Object dst, int dstOffset, int byteCount, byte[] src, int srcOffset, int sizeofElements, boolean swap) {
        if (!(dst instanceof int[])) {
            throw new RuntimeException("Unhandled unsafeBulkGet dst: " + dst);
        }
        Memory.unsafeBulkGet((int[])dst, dstOffset, byteCount, src, srcOffset, sizeofElements, swap);
    }

    public static void unsafeBulkGet(int[] dst, int dstOffset, int byteCount, byte[] src, int srcOffset, int sizeofElements, boolean swap) {
        int elementCount = byteCount / 4;
        ByteOrder order = swap ? SWAPPED : NATIVE;
        boolean isLittleEndian = order == ByteOrder.LITTLE_ENDIAN;
        for (int n = 0; n < elementCount; ++n) {
            dst[dstOffset + n] = Memory.peekInt(src, srcOffset + n * sizeofElements, isLittleEndian);
        }
    }
}

