/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.JTranscArrays;
import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String str;
    private int markpos = -1;
    private int pos;
    private int count;

    public StringReader(String str) {
        this.str = str;
        this.count = str.length();
    }

    @Override
    public void close() {
        this.str = null;
    }

    private boolean isClosed() {
        return this.str == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) throws IOException {
        if (readLimit < 0) {
            throw new IllegalArgumentException("readLimit < 0: " + readLimit);
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.markpos = this.pos;
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("StringReader is closed");
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos != this.count) {
                return this.str.charAt(this.pos++);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            JTranscArrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)count);
            if (count == 0) {
                return 0;
            }
            if (this.pos == this.count) {
                return -1;
            }
            int end = this.pos + count > this.count ? this.count : this.pos + count;
            this.str.getChars(this.pos, end, buffer, offset);
            int read = end - this.pos;
            this.pos = end;
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.pos = this.markpos != -1 ? this.markpos : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long charCount) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            int minSkip = -this.pos;
            int maxSkip = this.count - this.pos;
            if (maxSkip == 0 || charCount > (long)maxSkip) {
                charCount = maxSkip;
            } else if (charCount < (long)minSkip) {
                charCount = minSkip;
            }
            this.pos = (int)((long)this.pos + charCount);
            return charCount;
        }
    }
}

