/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscAddMembersList;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.internal.ByteBufferAs;
import libcore.io.Memory;

@HaxeAddMembers(value={"public var tarray:haxe.io.UInt16Array = null;"})
@JTranscAddMembersList(value={@JTranscAddMembers(target="dart", value={"Uint16List tarray;"}), @JTranscAddMembers(target="cpp", value={"uint16_t* tarray = nullptr;"}), @JTranscAddMembers(target="cs", value={"public byte[] tarray;"})})
abstract class ByteBufferAsCharBuffer
extends CharBuffer
implements ByteBufferAs {
    final ByteBuffer byteBuffer;
    final byte[] bytes;

    static CharBuffer asCharBuffer(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.order(byteBuffer.order());
        return ByteBufferAsCharBuffer.create(slice, byteBuffer.isLittleEndian);
    }

    private static ByteBufferAsCharBuffer create(ByteBuffer byteBuffer, boolean isLittleEndian) {
        return isLittleEndian ? new LE(byteBuffer) : new BE(byteBuffer);
    }

    private ByteBufferAsCharBuffer createWithSameOrder(ByteBuffer byteBuffer) {
        return ByteBufferAsCharBuffer.create(byteBuffer, this.order() == ByteOrder.LITTLE_ENDIAN);
    }

    private ByteBufferAsCharBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() / 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.bytes = byteBuffer.array();
        this.init(byteBuffer.array());
    }

    @HaxeMethodBody(value="this.tarray = haxe.io.UInt16Array.fromBytes(p0.data);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.tarray = new Uint16Array(p0.data.buffer);"}), @JTranscMethodBody(target="dart", value={"this.tarray = new Uint16List.view(p0.data.buffer);"}), @JTranscMethodBody(target="cpp", value={"this->tarray = (uint16_t *)(GET_OBJECT(JA_B, p0)->_data);"}), @JTranscMethodBody(target="cs", value={"unchecked { this.tarray = p0.u(); }"})})
    private void init(byte[] data) {
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        ByteBufferAsCharBuffer buf = this.createWithSameOrder(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        buf.byteBuffer.order = this.byteBuffer.order;
        return buf;
    }

    @Override
    public CharBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit * 2);
        this.byteBuffer.position(this.position * 2);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public CharBuffer duplicate() {
        ByteBuffer bb = this.byteBuffer.duplicate().order(this.byteBuffer.order());
        ByteBufferAsCharBuffer buf = this.createWithSameOrder(bb);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public char get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getChar(this.position++ * 2);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    char[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean protectedHasArray() {
        return false;
    }

    @Override
    public CharBuffer put(char c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putChar(this.position++ * 2, c);
        return this;
    }

    @Override
    public CharBuffer slice() {
        this.byteBuffer.limit(this.limit * 2);
        this.byteBuffer.position(this.position * 2);
        ByteBuffer bb = this.byteBuffer.slice().order(this.byteBuffer.order());
        ByteBufferAsCharBuffer result = this.createWithSameOrder(bb);
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        this.checkStartEndRemaining(start, end);
        CharBuffer result = this.duplicate();
        result.limit(this.position + end);
        result.position(this.position + start);
        return result;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    @HaxeMethodBody(value="return N.i2s(this.tarray.get(p0));")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this.tarray[p0];"}), @JTranscMethodBody(target="dart", value={"return this.tarray[p0];"}), @JTranscMethodBody(target="cpp", value={"return this->tarray[p0];"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { return ((ushort *)ptr)[p0]; } }"})})
    public char get(int index) {
        return Memory.peekAlignedCharLE(this.bytes, index);
    }

    @Override
    @HaxeMethodBody(value="this.tarray.set(p0, p1); return this;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="dart", value={"this.tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cpp", value={"this->tarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { ((ushort *)ptr)[p0] = p1; } } return this;"})})
    public CharBuffer put(int index, char c) {
        Memory.pokeAlignedCharLE(this.bytes, index, c);
        return this;
    }

    public static final class BE
    extends ByteBufferAsCharBuffer {
        BE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        public char get(int index) {
            return Character.reverseBytes(super.get(index));
        }

        @Override
        public CharBuffer put(int index, char c) {
            return super.put(index, Character.reverseBytes(c));
        }
    }

    public static final class LE
    extends ByteBufferAsCharBuffer {
        LE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }
    }
}

