/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscAddMembersList;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.internal.ByteBufferAs;
import libcore.io.Memory;

@HaxeAddMembers(value={"public var iarray:haxe.io.Int32Array = null; public var farray:haxe.io.Float32Array = null;"})
@JTranscAddMembersList(value={@JTranscAddMembers(target="dart", value={"Int32List iarray; Float32List farray;"}), @JTranscAddMembers(target="cpp", value={"int32_t* iarray = nullptr; float32_t* farray = nullptr;"}), @JTranscAddMembers(target="cs", value={"public byte[] tarray;"})})
class ByteBufferAsFloatBuffer
extends FloatBuffer
implements ByteBufferAs {
    final ByteBuffer byteBuffer;
    final byte[] bytes;

    static FloatBuffer asFloatBuffer(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        slice.order(byteBuffer.order());
        return ByteBufferAsFloatBuffer.create(slice, byteBuffer.isLittleEndian);
    }

    private static ByteBufferAsFloatBuffer create(ByteBuffer byteBuffer, boolean isLittleEndian) {
        return isLittleEndian ? new LE(byteBuffer) : new BE(byteBuffer);
    }

    private ByteBufferAsFloatBuffer createWithSameOrder(ByteBuffer byteBuffer) {
        return ByteBufferAsFloatBuffer.create(byteBuffer, this.order() == ByteOrder.LITTLE_ENDIAN);
    }

    ByteBufferAsFloatBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() / 4);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.bytes = byteBuffer.array();
        this.init(byteBuffer.array());
    }

    @HaxeMethodBody(value="this.iarray = haxe.io.Int32Array.fromBytes(p0.data); this.farray = haxe.io.Float32Array.fromBytes(p0.data);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.iarray = new Int32Array(p0.data.buffer); this.farray = new Float32Array(p0.data.buffer);"}), @JTranscMethodBody(target="dart", value={"this.iarray = new Int32List.view(p0.data.buffer); this.farray = new Float32List.view(p0.data.buffer);"}), @JTranscMethodBody(target="cpp", value={"this->iarray = (int32_t *)(GET_OBJECT(JA_B, p0)->_data); this->farray = (float32_t *)(GET_OBJECT(JA_B, p0)->_data);"}), @JTranscMethodBody(target="cs", value={"unchecked { this.tarray = (byte[])(Array)p0.data; }"})})
    private void init(byte[] data) {
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        ByteBufferAsFloatBuffer buf = (ByteBufferAsFloatBuffer)this.byteBuffer.asReadOnlyBuffer().asFloatBuffer();
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        buf.byteBuffer.order = this.byteBuffer.order;
        return buf;
    }

    @Override
    public FloatBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit * 4);
        this.byteBuffer.position(this.position * 4);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public FloatBuffer duplicate() {
        ByteBuffer bb = this.byteBuffer.duplicate().order(this.byteBuffer.order());
        ByteBufferAsFloatBuffer buf = this.createWithSameOrder(bb);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public float get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.get(this.position++);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    float[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean protectedHasArray() {
        return false;
    }

    @Override
    public FloatBuffer put(float c) {
        return this.put(this.position++, c);
    }

    @Override
    public FloatBuffer slice() {
        this.byteBuffer.limit(this.limit * 4);
        this.byteBuffer.position(this.position * 4);
        ByteBuffer bb = this.byteBuffer.slice().order(this.byteBuffer.order());
        ByteBufferAsFloatBuffer result = this.createWithSameOrder(bb);
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    @HaxeMethodBody(value="return this.farray.get(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this.farray[p0];"}), @JTranscMethodBody(target="dart", value={"return this.farray[p0];"}), @JTranscMethodBody(target="cpp", value={"return this->farray[p0];"}), @JTranscMethodBody(target="cs", value={"return BitConverter.ToSingle(this.tarray, p0);"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { return ((float *)ptr)[p0]; } }"})})
    public float get(int index) {
        return Memory.peekAlignedFloatLE(this.bytes, index);
    }

    @Override
    @HaxeMethodBody(value="this.farray.set(p0, p1); return this;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.farray[p0] = p1; return this;"}), @JTranscMethodBody(target="dart", value={"this.farray[p0] = p1; return this;"}), @JTranscMethodBody(target="cpp", value={"this->farray[p0] = p1; return this;"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { ((float *)ptr)[p0] = p1; } } return this;"})})
    public FloatBuffer put(int index, float c) {
        Memory.pokeAlignedFloatLE(this.bytes, index, c);
        return this;
    }

    @HaxeMethodBody(value="return this.iarray.get(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return this.iarray[p0];"}), @JTranscMethodBody(target="dart", value={"return this.iarray[p0];"}), @JTranscMethodBody(target="cpp", value={"return this->iarray[p0];"}), @JTranscMethodBody(target="cs", value={"return BitConverter.ToSingle(this.iarray, p0);"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { return ((int *)ptr)[p0]; } }"})})
    public int getInt(int index) {
        return Memory.peekAlignedIntLE(this.bytes, index);
    }

    @HaxeMethodBody(value="this.iarray.set(p0, p1); return this;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.iarray[p0] = p1; return this;"}), @JTranscMethodBody(target="dart", value={"this.iarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cpp", value={"this->iarray[p0] = p1; return this;"}), @JTranscMethodBody(target="cs", value={"unsafe { fixed (byte* ptr = this.tarray) { ((int *)ptr)[p0] = p1; } } return this;"})})
    public FloatBuffer putInt(int index, int c) {
        Memory.pokeAlignedIntLE(this.bytes, index, c);
        return this;
    }

    public static final class BE
    extends ByteBufferAsFloatBuffer {
        BE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }

        @Override
        public float get(int index) {
            return Float.intBitsToFloat(Integer.reverseBytes(this.getInt(index)));
        }

        @Override
        public FloatBuffer put(int index, float c) {
            return this.putInt(index, Integer.reverseBytes(Float.floatToRawIntBits(c)));
        }
    }

    public static final class LE
    extends ByteBufferAsFloatBuffer {
        LE(ByteBuffer byteBuffer) {
            super(byteBuffer);
        }
    }
}

