/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.Memory;

public final class HeapBufferIterator
extends BufferIterator {
    private final byte[] buffer;
    private final int offset;
    private final int byteCount;
    private final ByteOrder order;
    private int position;

    HeapBufferIterator(byte[] buffer, int offset, int byteCount, ByteOrder order) {
        this.buffer = buffer;
        this.offset = offset;
        this.byteCount = byteCount;
        this.order = order;
    }

    @Override
    public void seek(int offset) {
        this.position = offset;
    }

    @Override
    public void skip(int byteCount) {
        this.position += byteCount;
    }

    @Override
    public void readByteArray(byte[] dst, int dstOffset, int byteCount) {
        System.arraycopy(this.buffer, this.offset + this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
    }

    @Override
    public byte readByte() {
        byte result = this.buffer[this.offset + this.position];
        ++this.position;
        return result;
    }

    @Override
    public int readInt() {
        int result = Memory.peekInt(this.buffer, this.offset + this.position, this.order == ByteOrder.LITTLE_ENDIAN);
        this.position += 4;
        return result;
    }

    @Override
    public void readIntArray(int[] dst, int dstOffset, int intCount) {
        int byteCount = intCount * 4;
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.buffer, this.offset + this.position, 4, this.order != ByteOrder.nativeOrder());
        this.position += byteCount;
    }

    @Override
    public short readShort() {
        short result = Memory.peekShort(this.buffer, this.offset + this.position, this.order == ByteOrder.LITTLE_ENDIAN);
        this.position += 2;
        return result;
    }

    public static BufferIterator iterator(byte[] buffer, int offset, int byteCount, ByteOrder order) {
        return new HeapBufferIterator(buffer, offset, byteCount, order);
    }
}

