/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import libcore.io.Memory;

public final class UUID
implements Serializable,
Comparable<UUID> {
    private static SecureRandom rng;
    private long mostSigBits;
    private long leastSigBits;
    private transient int variant;
    private transient int version;
    private transient long timestamp;
    private transient int clockSequence;
    private transient long node;
    private transient int hash;

    public UUID(long mostSigBits, long leastSigBits) {
        this.mostSigBits = mostSigBits;
        this.leastSigBits = leastSigBits;
        this.init();
    }

    private void init() {
        int msbHash = (int)(this.mostSigBits ^ this.mostSigBits >>> 32);
        int lsbHash = (int)(this.leastSigBits ^ this.leastSigBits >>> 32);
        this.hash = msbHash ^ lsbHash;
        this.variant = (this.leastSigBits & Long.MIN_VALUE) == 0L ? 0 : ((this.leastSigBits & 0x4000000000000000L) != 0L ? (int)((this.leastSigBits & 0xE000000000000000L) >>> 61) : 2);
        this.version = (int)((this.mostSigBits & 0xF000L) >>> 12);
        if (this.variant != 2 && this.version != 1) {
            return;
        }
        long timeLow = (this.mostSigBits & 0xFFFFFFFF00000000L) >>> 32;
        long timeMid = (this.mostSigBits & 0xFFFF0000L) << 16;
        long timeHigh = (this.mostSigBits & 0xFFFL) << 48;
        this.timestamp = timeLow | timeMid | timeHigh;
        this.clockSequence = (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
        this.node = this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID randomUUID() {
        byte[] data = new byte[16];
        Class<UUID> clazz = UUID.class;
        synchronized (UUID.class) {
            if (rng == null) {
                rng = new SecureRandom();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            rng.nextBytes(data);
            return UUID.makeUuid(data, 4);
        }
    }

    public static UUID nameUUIDFromBytes(byte[] name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return UUID.makeUuid(md.digest(name), 3);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static UUID makeUuid(byte[] hash, int version) {
        long msb = Memory.peekLong(hash, 0, false);
        long lsb = Memory.peekLong(hash, 8, false);
        msb &= 0xFFFFFFFFFFFF0FFFL;
        lsb &= 0x3FFFFFFFFFFFFFFFL;
        return new UUID(msb |= (long)version << 12, lsb |= Long.MIN_VALUE);
    }

    public static UUID fromString(String uuid) {
        int i;
        if (uuid == null) {
            throw new NullPointerException("uuid == null");
        }
        int[] position = new int[5];
        int lastPosition = 1;
        int startPosition = 0;
        for (i = 0; i < position.length && lastPosition > 0; ++i) {
            position[i] = uuid.indexOf("-", startPosition);
            lastPosition = position[i];
            startPosition = position[i] + 1;
        }
        if (i != position.length || lastPosition != -1) {
            throw new IllegalArgumentException("Invalid UUID: " + uuid);
        }
        long m1 = Long.parseLong(uuid.substring(0, position[0]), 16);
        long m2 = Long.parseLong(uuid.substring(position[0] + 1, position[1]), 16);
        long m3 = Long.parseLong(uuid.substring(position[1] + 1, position[2]), 16);
        long lsb1 = Long.parseLong(uuid.substring(position[2] + 1, position[3]), 16);
        long lsb2 = Long.parseLong(uuid.substring(position[3] + 1), 16);
        long msb = m1 << 32 | m2 << 16 | m3;
        long lsb = lsb1 << 48 | lsb2;
        return new UUID(msb, lsb);
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        return this.version;
    }

    public int variant() {
        return this.variant;
    }

    public long timestamp() {
        if (this.version != 1) {
            throw new UnsupportedOperationException();
        }
        return this.timestamp;
    }

    public int clockSequence() {
        if (this.version != 1) {
            throw new UnsupportedOperationException();
        }
        return this.clockSequence;
    }

    public long node() {
        if (this.version != 1) {
            throw new UnsupportedOperationException();
        }
        return this.node;
    }

    @Override
    public int compareTo(UUID uuid) {
        if (uuid == this) {
            return 0;
        }
        if (this.mostSigBits != uuid.mostSigBits) {
            return this.mostSigBits < uuid.mostSigBits ? -1 : 1;
        }
        if (this.leastSigBits != uuid.leastSigBits) {
            return this.leastSigBits < uuid.leastSigBits ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof UUID)) {
            return false;
        }
        UUID that = (UUID)object;
        return this.leastSigBits == that.leastSigBits && this.mostSigBits == that.mostSigBits;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(36);
        String msbStr = Long.toHexString(this.mostSigBits);
        if (msbStr.length() < 16) {
            int diff = 16 - msbStr.length();
            for (int i = 0; i < diff; ++i) {
                builder.append('0');
            }
        }
        builder.append(msbStr);
        builder.insert(8, '-');
        builder.insert(13, '-');
        builder.append('-');
        String lsbStr = Long.toHexString(this.leastSigBits);
        if (lsbStr.length() < 16) {
            int diff = 16 - lsbStr.length();
            for (int i = 0; i < diff; ++i) {
                builder.append('0');
            }
        }
        builder.append(lsbStr);
        builder.insert(23, '-');
        return builder.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

