/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.jtransc.charset.ModifiedUtf8;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EmulatedFields;
import java.io.EmulatedFieldsForDumping;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.SerializationHandleMap;
import java.io.StreamCorruptedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import libcore.io.Memory;

public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final Class<?>[] WRITE_UNSHARED_PARAM_TYPES = new Class[]{Object.class};
    private static final byte NOT_SC_BLOCK_DATA = -9;
    private int nestedLevels;
    private DataOutputStream output;
    private boolean enableReplace;
    private DataOutputStream primitiveTypes;
    private ByteArrayOutputStream primitiveTypesBuffer;
    private SerializationHandleMap objectsWritten;
    private int currentHandle;
    private Object currentObject;
    private ObjectStreamClass currentClass;
    private int protocolVersion;
    private StreamCorruptedException nestedException;
    private EmulatedFieldsForDumping currentPutField;
    private boolean subclassOverridingImplementation;
    private final ObjectStreamClass proxyClassDesc = ObjectStreamClass.lookup(Proxy.class);

    protected ObjectOutputStream() throws IOException {
        this.subclassOverridingImplementation = true;
    }

    public ObjectOutputStream(OutputStream output) throws IOException {
        this.output = output instanceof DataOutputStream ? (DataOutputStream)output : new DataOutputStream(output);
        this.enableReplace = false;
        this.protocolVersion = 2;
        this.subclassOverridingImplementation = false;
        this.resetState();
        this.nestedException = new StreamCorruptedException();
        this.primitiveTypes = this.output;
        this.writeStreamHeader();
        this.primitiveTypes = null;
    }

    protected void annotateClass(Class<?> aClass) throws IOException {
    }

    protected void annotateProxyClass(Class<?> aClass) throws IOException {
    }

    private void checkWritePrimitiveTypes() {
        if (this.primitiveTypes == null) {
            this.primitiveTypesBuffer = new ByteArrayOutputStream(128);
            this.primitiveTypes = new DataOutputStream(this.primitiveTypesBuffer);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    private void computePutField() {
        this.currentPutField = new EmulatedFieldsForDumping(this, this.currentClass);
    }

    public void defaultWriteObject() throws IOException {
        if (this.currentObject == null) {
            throw new NotActiveException();
        }
        this.writeFieldValues(this.currentObject, this.currentClass);
    }

    protected void drain() throws IOException {
        int toWrite;
        if (this.primitiveTypes == null || this.primitiveTypesBuffer == null) {
            return;
        }
        byte[] written = this.primitiveTypesBuffer.toByteArray();
        for (int offset = 0; offset < written.length; offset += toWrite) {
            int n = toWrite = written.length - offset > 1024 ? 1024 : written.length - offset;
            if (toWrite < 256) {
                this.output.writeByte(119);
                this.output.writeByte((byte)toWrite);
            } else {
                this.output.writeByte(122);
                this.output.writeInt(toWrite);
            }
            this.output.write(written, offset, toWrite);
        }
        this.primitiveTypes = null;
        this.primitiveTypesBuffer = null;
    }

    private int dumpCycle(Object obj) throws IOException {
        int handle = this.objectsWritten.get(obj);
        if (handle != -1) {
            this.writeCyclicReference(handle);
            return handle;
        }
        return -1;
    }

    protected boolean enableReplaceObject(boolean enable) {
        boolean originalValue = this.enableReplace;
        this.enableReplace = enable;
        return originalValue;
    }

    @Override
    public void flush() throws IOException {
        this.drain();
        this.output.flush();
    }

    private static native Object getFieldL(Object var0, Class<?> var1, String var2, String var3);

    private int nextHandle() {
        return this.currentHandle++;
    }

    public PutField putFields() throws IOException {
        if (this.currentObject == null) {
            throw new NotActiveException();
        }
        if (this.currentPutField == null) {
            this.computePutField();
        }
        return this.currentPutField;
    }

    private int registerObjectWritten(Object obj) {
        int handle = this.nextHandle();
        this.objectsWritten.put(obj, handle);
        return handle;
    }

    private void removeUnsharedReference(Object obj, int previousHandle) {
        if (previousHandle != -1) {
            this.objectsWritten.put(obj, previousHandle);
        } else {
            this.objectsWritten.remove(obj);
        }
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    public void reset() throws IOException {
        this.drain();
        this.output.writeByte(121);
        this.resetState();
    }

    private void resetSeenObjects() {
        this.objectsWritten = new SerializationHandleMap();
        this.currentHandle = 0x7E0000;
    }

    private void resetState() {
        this.resetSeenObjects();
        this.nestedLevels = 0;
    }

    public void useProtocolVersion(int version) throws IOException {
        if (!this.objectsWritten.isEmpty()) {
            throw new IllegalStateException("Cannot set protocol version when stream in use");
        }
        if (version != 1 && version != 2) {
            throw new IllegalArgumentException("Unknown protocol: " + version);
        }
        this.protocolVersion = version;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.write(buffer, offset, length);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.write(value);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeBoolean(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeByte(value);
    }

    @Override
    public void writeBytes(String value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeBytes(value);
    }

    @Override
    public void writeChar(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeChar(value);
    }

    @Override
    public void writeChars(String value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeChars(value);
    }

    private int writeClassDesc(ObjectStreamClass classDesc, boolean unshared) throws IOException {
        if (classDesc == null) {
            this.writeNull();
            return -1;
        }
        int handle = -1;
        if (!unshared) {
            handle = this.dumpCycle(classDesc);
        }
        if (handle == -1) {
            Class<?> classToWrite = classDesc.forClass();
            int previousHandle = -1;
            if (unshared) {
                previousHandle = this.objectsWritten.get(classDesc);
            }
            handle = this.registerObjectWritten(classDesc);
            if (classDesc.isProxy()) {
                this.output.writeByte(125);
                Class<?>[] interfaces = classToWrite.getInterfaces();
                this.output.writeInt(interfaces.length);
                for (int i = 0; i < interfaces.length; ++i) {
                    this.output.writeUTF(interfaces[i].getName());
                }
                this.annotateProxyClass(classToWrite);
                this.output.writeByte(120);
                this.writeClassDesc(this.proxyClassDesc, false);
                if (unshared) {
                    this.removeUnsharedReference(classDesc, previousHandle);
                }
                return handle;
            }
            this.output.writeByte(114);
            if (this.protocolVersion == 1) {
                this.writeNewClassDesc(classDesc);
            } else {
                this.primitiveTypes = this.output;
                this.writeClassDescriptor(classDesc);
                this.primitiveTypes = null;
            }
            this.annotateClass(classToWrite);
            this.drain();
            this.output.writeByte(120);
            this.writeClassDesc(classDesc.getSuperclass(), unshared);
            if (unshared) {
                this.removeUnsharedReference(classDesc, previousHandle);
            }
        }
        return handle;
    }

    private void writeCyclicReference(int handle) throws IOException {
        this.output.writeByte(113);
        this.output.writeInt(handle);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeDouble(value);
    }

    private void writeFieldDescriptors(ObjectStreamClass classDesc, boolean externalizable) throws IOException {
        Class<?> loadedClass = classDesc.forClass();
        ObjectStreamField[] fields = null;
        int fieldCount = 0;
        if (!externalizable && loadedClass != ObjectStreamClass.STRINGCLASS) {
            fields = classDesc.fields();
            fieldCount = fields.length;
        }
        this.output.writeShort(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            ObjectStreamField f = fields[i];
            boolean wasPrimitive = f.writeField(this.output);
            if (wasPrimitive) continue;
            this.writeObject(f.getTypeString());
        }
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException();
        }
        this.writeFieldValues(this.currentPutField);
    }

    private void writeFieldValues(EmulatedFieldsForDumping emulatedFields) throws IOException {
        EmulatedFields accessibleSimulatedFields = emulatedFields.emulatedFields();
        for (EmulatedFields.ObjectSlot slot : accessibleSimulatedFields.slots()) {
            Object fieldValue = slot.getFieldValue();
            Class<?> type = slot.getField().getType();
            if (type == Integer.TYPE) {
                this.output.writeInt(fieldValue != null ? (Integer)fieldValue : 0);
                continue;
            }
            if (type == Byte.TYPE) {
                this.output.writeByte(fieldValue != null ? (int)((Byte)fieldValue).byteValue() : 0);
                continue;
            }
            if (type == Character.TYPE) {
                this.output.writeChar(fieldValue != null ? (int)((Character)fieldValue).charValue() : 0);
                continue;
            }
            if (type == Short.TYPE) {
                this.output.writeShort(fieldValue != null ? (int)((Short)fieldValue).shortValue() : 0);
                continue;
            }
            if (type == Boolean.TYPE) {
                this.output.writeBoolean(fieldValue != null ? (Boolean)fieldValue : false);
                continue;
            }
            if (type == Long.TYPE) {
                this.output.writeLong(fieldValue != null ? (Long)fieldValue : 0L);
                continue;
            }
            if (type == Float.TYPE) {
                this.output.writeFloat(fieldValue != null ? ((Float)fieldValue).floatValue() : 0.0f);
                continue;
            }
            if (type == Double.TYPE) {
                this.output.writeDouble(fieldValue != null ? (Double)fieldValue : 0.0);
                continue;
            }
            this.writeObject(fieldValue);
        }
    }

    private void writeFieldValues(Object obj, ObjectStreamClass classDesc) throws IOException {
        for (ObjectStreamField fieldDesc : classDesc.fields()) {
            try {
                Class<?> type = fieldDesc.getTypeInternal();
                Field field = classDesc.getReflectionField(fieldDesc);
                if (field == null) {
                    throw new InvalidClassException(classDesc.getName() + " doesn't have a field " + fieldDesc.getName() + " of type " + type);
                }
                if (type == Byte.TYPE) {
                    this.output.writeByte(field.getByte(obj));
                    continue;
                }
                if (type == Character.TYPE) {
                    this.output.writeChar(field.getChar(obj));
                    continue;
                }
                if (type == Double.TYPE) {
                    this.output.writeDouble(field.getDouble(obj));
                    continue;
                }
                if (type == Float.TYPE) {
                    this.output.writeFloat(field.getFloat(obj));
                    continue;
                }
                if (type == Integer.TYPE) {
                    this.output.writeInt(field.getInt(obj));
                    continue;
                }
                if (type == Long.TYPE) {
                    this.output.writeLong(field.getLong(obj));
                    continue;
                }
                if (type == Short.TYPE) {
                    this.output.writeShort(field.getShort(obj));
                    continue;
                }
                if (type == Boolean.TYPE) {
                    this.output.writeBoolean(field.getBoolean(obj));
                    continue;
                }
                Object objField = field.get(obj);
                if (fieldDesc.isUnshared()) {
                    this.writeUnshared(objField);
                    continue;
                }
                this.writeObject(objField);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
            catch (NoSuchFieldError nsf) {
                throw new InvalidClassException(classDesc.getName());
            }
        }
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeFloat(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHierarchy(Object object, ObjectStreamClass classDesc) throws IOException, NotActiveException {
        if (object == null) {
            throw new NotActiveException();
        }
        List<ObjectStreamClass> hierarchy = classDesc.getHierarchy();
        int end = hierarchy.size();
        for (int i = 0; i < end; ++i) {
            ObjectStreamClass osc = hierarchy.get(i);
            this.currentObject = object;
            this.currentClass = osc;
            try {
                boolean executed = false;
                if (osc.hasMethodWriteObject()) {
                    Method method = osc.getMethodWriteObject();
                    try {
                        method.invoke(object, this);
                        executed = true;
                    }
                    catch (InvocationTargetException e) {
                        Throwable ex = e.getTargetException();
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                        if (ex instanceof Error) {
                            throw (Error)ex;
                        }
                        throw (IOException)ex;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
                if (executed) {
                    this.drain();
                    this.output.writeByte(120);
                    continue;
                }
                this.defaultWriteObject();
                continue;
            }
            finally {
                this.currentObject = null;
                this.currentClass = null;
                this.currentPutField = null;
            }
        }
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeLong(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int writeNewArray(Object array, Class<?> arrayClass, ObjectStreamClass arrayClDesc, Class<?> componentType, boolean unshared) throws IOException {
        this.output.writeByte(117);
        this.writeClassDesc(arrayClDesc, false);
        int handle = this.nextHandle();
        if (!unshared) {
            this.objectsWritten.put(array, handle);
        }
        if (componentType.isPrimitive()) {
            if (componentType == Integer.TYPE) {
                int[] intArray = (int[])array;
                this.output.writeInt(intArray.length);
                for (int i = 0; i < intArray.length; ++i) {
                    this.output.writeInt(intArray[i]);
                }
                return handle;
            } else if (componentType == Byte.TYPE) {
                byte[] byteArray = (byte[])array;
                this.output.writeInt(byteArray.length);
                this.output.write(byteArray, 0, byteArray.length);
                return handle;
            } else if (componentType == Character.TYPE) {
                char[] charArray = (char[])array;
                this.output.writeInt(charArray.length);
                for (int i = 0; i < charArray.length; ++i) {
                    this.output.writeChar(charArray[i]);
                }
                return handle;
            } else if (componentType == Short.TYPE) {
                short[] shortArray = (short[])array;
                this.output.writeInt(shortArray.length);
                for (int i = 0; i < shortArray.length; ++i) {
                    this.output.writeShort(shortArray[i]);
                }
                return handle;
            } else if (componentType == Boolean.TYPE) {
                boolean[] booleanArray = (boolean[])array;
                this.output.writeInt(booleanArray.length);
                for (int i = 0; i < booleanArray.length; ++i) {
                    this.output.writeBoolean(booleanArray[i]);
                }
                return handle;
            } else if (componentType == Long.TYPE) {
                long[] longArray = (long[])array;
                this.output.writeInt(longArray.length);
                for (int i = 0; i < longArray.length; ++i) {
                    this.output.writeLong(longArray[i]);
                }
                return handle;
            } else if (componentType == Float.TYPE) {
                float[] floatArray = (float[])array;
                this.output.writeInt(floatArray.length);
                for (int i = 0; i < floatArray.length; ++i) {
                    this.output.writeFloat(floatArray[i]);
                }
                return handle;
            } else {
                if (componentType != Double.TYPE) throw new InvalidClassException("Wrong base type in " + arrayClass.getName());
                double[] doubleArray = (double[])array;
                this.output.writeInt(doubleArray.length);
                for (int i = 0; i < doubleArray.length; ++i) {
                    this.output.writeDouble(doubleArray[i]);
                }
            }
            return handle;
        } else {
            Object[] objectArray = (Object[])array;
            this.output.writeInt(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                this.writeObject(objectArray[i]);
            }
        }
        return handle;
    }

    private int writeNewClass(Class<?> object, boolean unshared) throws IOException {
        this.output.writeByte(118);
        ObjectStreamClass clDesc = ObjectStreamClass.lookupStreamClass(object);
        if (clDesc.isEnum()) {
            this.writeEnumDesc(object, clDesc, unshared);
        } else {
            this.writeClassDesc(clDesc, unshared);
        }
        int handle = this.nextHandle();
        if (!unshared) {
            this.objectsWritten.put(object, handle);
        }
        return handle;
    }

    private void writeNewClassDesc(ObjectStreamClass classDesc) throws IOException {
        this.output.writeUTF(classDesc.getName());
        this.output.writeLong(classDesc.getSerialVersionUID());
        byte flags = classDesc.getFlags();
        boolean externalizable = classDesc.isExternalizable();
        if (externalizable) {
            flags = this.protocolVersion == 1 ? (byte)(flags & 0xFFFFFFF7) : (byte)(flags | 8);
        }
        this.output.writeByte(flags);
        if (18 != classDesc.getFlags()) {
            this.writeFieldDescriptors(classDesc, externalizable);
        } else {
            this.output.writeShort(0);
        }
    }

    protected void writeClassDescriptor(ObjectStreamClass classDesc) throws IOException {
        this.writeNewClassDesc(classDesc);
    }

    private void writeNewException(Exception ex) throws IOException {
        this.output.writeByte(123);
        this.resetSeenObjects();
        this.writeObjectInternal(ex, false, false, false);
        this.resetSeenObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeNewObject(Object object, Class<?> theClass, ObjectStreamClass clDesc, boolean unshared) throws IOException {
        EmulatedFieldsForDumping originalCurrentPutField = this.currentPutField;
        this.currentPutField = null;
        boolean externalizable = clDesc.isExternalizable();
        boolean serializable = clDesc.isSerializable();
        if (!externalizable && !serializable) {
            throw new NotSerializableException(theClass.getName());
        }
        this.output.writeByte(115);
        this.writeClassDesc(clDesc, false);
        int previousHandle = -1;
        if (unshared) {
            previousHandle = this.objectsWritten.get(object);
        }
        int handle = this.registerObjectWritten(object);
        this.currentObject = object;
        this.currentClass = clDesc;
        try {
            if (externalizable) {
                boolean noBlockData;
                boolean bl = noBlockData = this.protocolVersion == 1;
                if (noBlockData) {
                    this.primitiveTypes = this.output;
                }
                ((Externalizable)object).writeExternal(this);
                if (noBlockData) {
                    this.primitiveTypes = null;
                } else {
                    this.drain();
                    this.output.writeByte(120);
                }
            } else {
                this.writeHierarchy(object, this.currentClass);
            }
        }
        finally {
            if (unshared) {
                this.removeUnsharedReference(object, previousHandle);
            }
            this.currentObject = null;
            this.currentClass = null;
            this.currentPutField = originalCurrentPutField;
        }
        return handle;
    }

    private int writeNewString(String object, boolean unshared) throws IOException {
        byte[] buffer;
        long count = ModifiedUtf8.countBytes((String)object, (boolean)false);
        int offset = 0;
        if (count <= 65535L) {
            buffer = new byte[3 + (int)count];
            buffer[offset++] = 116;
            Memory.pokeShort(buffer, offset, (short)count, false);
            offset += 2;
        } else {
            buffer = new byte[9 + (int)count];
            buffer[offset++] = 124;
            Memory.pokeLong(buffer, offset, count, false);
            offset += 8;
        }
        ModifiedUtf8.encode((byte[])buffer, (int)offset, (String)object);
        this.output.write(buffer, 0, buffer.length);
        int handle = this.nextHandle();
        if (!unshared) {
            this.objectsWritten.put(object, handle);
        }
        return handle;
    }

    private void writeNull() throws IOException {
        this.output.writeByte(112);
    }

    @Override
    public final void writeObject(Object object) throws IOException {
        this.writeObject(object, false);
    }

    public void writeUnshared(Object object) throws IOException {
        this.writeObject(object, true);
    }

    private void writeObject(Object object, boolean unshared) throws IOException {
        boolean setOutput;
        boolean bl = setOutput = this.primitiveTypes == this.output;
        if (setOutput) {
            this.primitiveTypes = null;
        }
        if (this.subclassOverridingImplementation && !unshared) {
            this.writeObjectOverride(object);
            return;
        }
        try {
            this.drain();
            this.writeObjectInternal(object, unshared, true, true);
            if (setOutput) {
                this.primitiveTypes = this.output;
            }
        }
        catch (IOException ioEx1) {
            if (this.nestedLevels == 0 && ioEx1 != this.nestedException) {
                try {
                    this.writeNewException(ioEx1);
                }
                catch (IOException ioEx2) {
                    this.nestedException.fillInStackTrace();
                    throw this.nestedException;
                }
            }
            throw ioEx1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeObjectInternal(Object object, boolean unshared, boolean computeClassBasedReplacement, boolean computeStreamReplacement) throws IOException {
        if (object == null) {
            this.writeNull();
            return -1;
        }
        int handle = -1;
        if (!unshared && (handle = this.dumpCycle(object)) != -1) {
            return handle;
        }
        Class<?> objClass = object.getClass();
        ObjectStreamClass clDesc = ObjectStreamClass.lookupStreamClass(objClass);
        ++this.nestedLevels;
        try {
            Object streamReplacement;
            if (!this.enableReplace || !computeStreamReplacement) {
                if (objClass == ObjectStreamClass.CLASSCLASS) {
                    int n = this.writeNewClass((Class)object, unshared);
                    return n;
                }
                if (objClass == ObjectStreamClass.OBJECTSTREAMCLASSCLASS) {
                    int n = this.writeClassDesc((ObjectStreamClass)object, unshared);
                    return n;
                }
            }
            if (clDesc.isSerializable() && computeClassBasedReplacement && clDesc.hasMethodWriteReplace()) {
                Method methodWriteReplace = clDesc.getMethodWriteReplace();
                Object replObj = null;
                try {
                    replObj = methodWriteReplace.invoke(object, null);
                }
                catch (IllegalAccessException iae) {
                    replObj = object;
                }
                catch (InvocationTargetException ite) {
                    Throwable target = ite.getTargetException();
                    if (target instanceof ObjectStreamException) {
                        throw (ObjectStreamException)target;
                    }
                    if (target instanceof Error) {
                        throw (Error)target;
                    }
                    throw (RuntimeException)target;
                }
                if (replObj != object) {
                    int replacementHandle = this.writeObjectInternal(replObj, false, false, computeStreamReplacement);
                    if (replacementHandle != -1) {
                        this.objectsWritten.put(object, replacementHandle);
                    }
                    int n = replacementHandle;
                    return n;
                }
            }
            if (this.enableReplace && computeStreamReplacement && (streamReplacement = this.replaceObject(object)) != object) {
                int replacementHandle = this.writeObjectInternal(streamReplacement, false, computeClassBasedReplacement, false);
                if (replacementHandle != -1) {
                    this.objectsWritten.put(object, replacementHandle);
                }
                int n = replacementHandle;
                return n;
            }
            if (objClass == ObjectStreamClass.CLASSCLASS) {
                int n = this.writeNewClass((Class)object, unshared);
                return n;
            }
            if (objClass == ObjectStreamClass.OBJECTSTREAMCLASSCLASS) {
                int n = this.writeClassDesc((ObjectStreamClass)object, unshared);
                return n;
            }
            if (objClass == ObjectStreamClass.STRINGCLASS) {
                int n = this.writeNewString((String)object, unshared);
                return n;
            }
            if (objClass.isArray()) {
                int n = this.writeNewArray(object, objClass, clDesc, objClass.getComponentType(), unshared);
                return n;
            }
            if (object instanceof Enum) {
                int n = this.writeNewEnum(object, objClass, unshared);
                return n;
            }
            int n = this.writeNewObject(object, objClass, clDesc, unshared);
            return n;
        }
        finally {
            --this.nestedLevels;
        }
    }

    private ObjectStreamClass writeEnumDesc(Class<?> theClass, ObjectStreamClass classDesc, boolean unshared) throws IOException {
        classDesc.setFlags((byte)18);
        int previousHandle = -1;
        if (unshared) {
            previousHandle = this.objectsWritten.get(classDesc);
        }
        int handle = -1;
        if (!unshared) {
            handle = this.dumpCycle(classDesc);
        }
        if (handle == -1) {
            Class<?> classToWrite = classDesc.forClass();
            this.registerObjectWritten(classDesc);
            this.output.writeByte(114);
            if (this.protocolVersion == 1) {
                this.writeNewClassDesc(classDesc);
            } else {
                this.primitiveTypes = this.output;
                this.writeClassDescriptor(classDesc);
                this.primitiveTypes = null;
            }
            this.annotateClass(classToWrite);
            this.drain();
            this.output.writeByte(120);
            ObjectStreamClass superClassDesc = classDesc.getSuperclass();
            if (superClassDesc != null) {
                superClassDesc.setFlags((byte)18);
                this.writeEnumDesc(superClassDesc.forClass(), superClassDesc, unshared);
            } else {
                this.output.writeByte(112);
            }
            if (unshared) {
                this.removeUnsharedReference(classDesc, previousHandle);
            }
        }
        return classDesc;
    }

    private int writeNewEnum(Object object, Class<?> theClass, boolean unshared) throws IOException {
        EmulatedFieldsForDumping originalCurrentPutField = this.currentPutField;
        this.currentPutField = null;
        this.output.writeByte(126);
        while (theClass != null && !theClass.isEnum()) {
            theClass = theClass.getSuperclass();
        }
        ObjectStreamClass classDesc = ObjectStreamClass.lookup(theClass);
        this.writeEnumDesc(theClass, classDesc, unshared);
        int previousHandle = -1;
        if (unshared) {
            previousHandle = this.objectsWritten.get(object);
        }
        int handle = this.registerObjectWritten(object);
        ObjectStreamField[] fields = classDesc.getSuperclass().fields();
        if (fields != null && fields.length > 1) {
            Field field = classDesc.getSuperclass().getReflectionField(fields[1]);
            if (field == null) {
                throw new NoSuchFieldError();
            }
            try {
                String str = (String)field.get(object);
                int strHandle = -1;
                if (!unshared) {
                    strHandle = this.dumpCycle(str);
                }
                if (strHandle == -1) {
                    this.writeNewString(str, unshared);
                }
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }
        if (unshared) {
            this.removeUnsharedReference(object, previousHandle);
        }
        this.currentPutField = originalCurrentPutField;
        return handle;
    }

    protected void writeObjectOverride(Object object) throws IOException {
        if (!this.subclassOverridingImplementation) {
            throw new IOException();
        }
    }

    @Override
    public void writeShort(int value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeShort(value);
    }

    protected void writeStreamHeader() throws IOException {
        this.output.writeShort(-21267);
        this.output.writeShort(5);
    }

    @Override
    public void writeUTF(String value) throws IOException {
        this.checkWritePrimitiveTypes();
        this.primitiveTypes.writeUTF(value);
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

