/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.jtransc.text.JTranscLocale;
import com.jtransc.text.JTranscStringTools;
import com.jtransc.util.JTranscStrings;
import java.io.InvalidObjectException;
import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class NumberFormat
extends Format {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private boolean parseIntegerOnly = false;
    private boolean groupingUsed = true;
    private int maximumIntegerDigits = 100;
    private int minimumIntegerDigits = 1;
    private int maximumFractionDigits = 100;
    private int minimumFractionDigits = 0;
    private RoundingMode roundingMode = RoundingMode.HALF_EVEN;
    private Locale locale;
    private int intGroupDigits = 3;
    private String intGroupSeparator = ".";
    private String commaSeparator = ",";
    private Currency currency;

    protected NumberFormat() {
        this(Locale.getDefault());
    }

    private NumberFormat(Locale locale) {
        this.locale = locale;
        this.intGroupDigits = JTranscLocale.getIntNumberOfDigits((Locale)locale);
        this.intGroupSeparator = JTranscLocale.getGroupSeparator((Locale)locale);
        this.commaSeparator = JTranscLocale.getDecimalSeparator((Locale)locale);
    }

    @Override
    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        toAppendTo.append(this.format((Number)number));
        return toAppendTo;
    }

    @Override
    public final Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    private String format(Number value) {
        return this._format(value.toString());
    }

    public final String format(double value) {
        return this._format(JTranscStringTools.toString((double)value));
    }

    public final String format(long value) {
        return this._format(Long.toString(value));
    }

    private String _format(String value) {
        return this._formatInt(value);
    }

    private String _formatInt(String value) {
        return JTranscStrings.join((String[])JTranscStrings.splitInChunksRightToLeft((String)value, (int)this.intGroupDigits), (String)this.intGroupSeparator);
    }

    public StringBuffer format(double value, StringBuffer toAppendTo, FieldPosition pos) {
        toAppendTo.append(this.format(value));
        return toAppendTo;
    }

    public StringBuffer format(long value, StringBuffer toAppendTo, FieldPosition pos) {
        toAppendTo.append(this.format(value));
        return toAppendTo;
    }

    public native Number parse(String var1, ParsePosition var2);

    public Number parse(String source) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number result = this.parse(source, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("Unparseable number: \"" + source + "\"", parsePosition.errorIndex);
        }
        return result;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public void setParseIntegerOnly(boolean value) {
        this.parseIntegerOnly = value;
    }

    public static NumberFormat getInstance() {
        return new NumberFormat();
    }

    public static NumberFormat getInstance(Locale locale) {
        return new NumberFormat(locale);
    }

    public static NumberFormat getNumberInstance() {
        return new NumberFormat();
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        return new NumberFormat(locale);
    }

    public static NumberFormat getIntegerInstance() {
        return new NumberFormat();
    }

    public static NumberFormat getIntegerInstance(Locale locale) {
        return new NumberFormat(locale);
    }

    public static NumberFormat getCurrencyInstance() {
        return new NumberFormat();
    }

    public static NumberFormat getCurrencyInstance(Locale inLocale) {
        return new NumberFormat();
    }

    public static NumberFormat getPercentInstance() {
        return NumberFormat.getPercentInstance(Locale.getDefault(Locale.Category.FORMAT));
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return new NumberFormat(locale);
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{Locale.ENGLISH};
    }

    public int hashCode() {
        return this.getMaximumIntegerDigits() * 37 + this.getMaximumFractionDigits();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberFormat that = (NumberFormat)obj;
        return this.getMaximumIntegerDigits() == that.getMaximumIntegerDigits() && this.getMinimumIntegerDigits() == that.getMinimumIntegerDigits() && this.getMaximumFractionDigits() == that.getMaximumFractionDigits() && this.getMinimumFractionDigits() == that.getMinimumFractionDigits() && this.isGroupingUsed() == that.isGroupingUsed() && this.isParseIntegerOnly() == that.isParseIntegerOnly();
    }

    @Override
    public Object clone() {
        NumberFormat other = (NumberFormat)super.clone();
        return other;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean newValue) {
        this.groupingUsed = newValue;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.maximumIntegerDigits = newValue;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.minimumIntegerDigits = newValue;
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setMaximumFractionDigits(int newValue) {
        this.maximumFractionDigits = newValue;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public void setMinimumFractionDigits(int newValue) {
        this.minimumFractionDigits = newValue;
    }

    public Currency getCurrency() {
        if (this.currency == null) {
            this.currency = Currency.getInstance(this.locale);
        }
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public static class Field
    extends Format.Field {
        private static final Map<String, Field> instances = new HashMap<String, Field>(11);
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field SIGN = new Field("sign");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("per mille");
        public static final Field CURRENCY = new Field("currency");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");

        protected Field(String name) {
            super(name);
            instances.put(name, this);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            return instances.get(this.getName());
        }
    }
}

