/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;

public abstract class Clock {
    private static Clock systemUTC;

    protected Clock() {
    }

    public static Clock systemUTC() {
        if (systemUTC == null) {
            systemUTC = new SimplifiedClock(){

                @Override
                public long millis() {
                    return System.currentTimeMillis();
                }
            };
        }
        return systemUTC;
    }

    public static Clock systemDefaultZone() {
        return Clock.systemUTC();
    }

    public static Clock system(ZoneId zone) {
        return Clock.systemUTC();
    }

    public static Clock tickSeconds(ZoneId zone) {
        return Clock.tick(Clock.system(zone), Duration.ofSeconds(1L));
    }

    public static Clock tickMinutes(ZoneId zone) {
        return Clock.tick(Clock.system(zone), Duration.ofMinutes(1L));
    }

    public static Clock tick(final Clock baseClock, Duration tickDuration) {
        final long tickMillis = tickDuration.toMillis();
        return new SimplifiedClock(){

            @Override
            public long millis() {
                return baseClock.millis() / tickMillis * tickMillis;
            }
        };
    }

    public static Clock fixed(Instant fixedInstant, final ZoneId zone) {
        final long fixedMillis = fixedInstant.toEpochMilli();
        return new SimplifiedClock(){

            @Override
            public ZoneId getZone() {
                return zone;
            }

            @Override
            public long millis() {
                return fixedMillis;
            }
        };
    }

    public static Clock offset(final Clock baseClock, Duration offsetDuration) {
        final long add = offsetDuration.toMillis();
        return new SimplifiedClock(){

            @Override
            public long millis() {
                return baseClock.millis() + add;
            }
        };
    }

    public ZoneId getZone() {
        return ZoneId.systemDefault();
    }

    public abstract Clock withZone(ZoneId var1);

    public long millis() {
        return this.instant().toEpochMilli();
    }

    public abstract Instant instant();

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    private static abstract class SimplifiedClock
    extends Clock {
        private SimplifiedClock() {
        }

        @Override
        public ZoneId getZone() {
            return ZoneId.systemDefault();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return this;
        }

        @Override
        public abstract long millis();

        @Override
        public Instant instant() {
            return Instant.ofEpochMilli(this.millis());
        }
    }
}

