/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import com.jtransc.IntegerUtils;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import java.util.Locale;

public enum DayOfWeek implements TemporalAccessor,
TemporalAdjuster
{
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;


    public static DayOfWeek of(int dayOfWeek) {
        return DayOfWeek.values()[dayOfWeek - 1];
    }

    public static native DayOfWeek from(TemporalAccessor var0);

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(TextStyle style, Locale locale) {
        return this.name();
    }

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public long getLong(TemporalField field) {
        return field == ChronoField.DAY_OF_WEEK ? (long)this.getValue() : 0L;
    }

    private DayOfWeek _plus(long days) {
        return DayOfWeek.of(IntegerUtils.umod((int)((long)this.ordinal() + days), 7));
    }

    public DayOfWeek plus(long days) {
        return this._plus(days);
    }

    public DayOfWeek minus(long days) {
        return this._plus(-days);
    }

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native Temporal adjustInto(Temporal var1);
}

