/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;

public final class LocalDateTime
implements Temporal,
TemporalAdjuster,
ChronoLocalDateTime<LocalDate>,
Serializable {
    public static final LocalDateTime MIN = new LocalDateTime(LocalDate.MIN, LocalTime.MIN);
    public static final LocalDateTime MAX = new LocalDateTime(LocalDate.MAX, LocalTime.MAX);
    private final LocalDate date;
    private final LocalTime time;

    private LocalDateTime(LocalDate date, LocalTime time) {
        this.date = date;
        this.time = time;
    }

    public static native LocalDateTime now();

    public static native LocalDateTime now(ZoneId var0);

    public static native LocalDateTime now(Clock var0);

    public static native LocalDateTime of(int var0, Month var1, int var2, int var3, int var4);

    public static native LocalDateTime of(int var0, Month var1, int var2, int var3, int var4, int var5);

    public static native LocalDateTime of(int var0, Month var1, int var2, int var3, int var4, int var5, int var6);

    public static native LocalDateTime of(int var0, int var1, int var2, int var3, int var4);

    public static native LocalDateTime of(int var0, int var1, int var2, int var3, int var4, int var5);

    public static native LocalDateTime of(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    public static native LocalDateTime of(LocalDate var0, LocalTime var1);

    public static native LocalDateTime ofInstant(Instant var0, ZoneId var1);

    public static native LocalDateTime ofEpochSecond(long var0, int var2, ZoneOffset var3);

    public static native LocalDateTime from(TemporalAccessor var0);

    public static native LocalDateTime parse(CharSequence var0);

    public static native LocalDateTime parse(CharSequence var0, DateTimeFormatter var1);

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native boolean isSupported(TemporalUnit var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public native int get(TemporalField var1);

    @Override
    public native long getLong(TemporalField var1);

    @Override
    public native LocalDate toLocalDate();

    public native int getYear();

    public native int getMonthValue();

    public native Month getMonth();

    public native int getDayOfMonth();

    public native int getDayOfYear();

    public native DayOfWeek getDayOfWeek();

    @Override
    public native LocalTime toLocalTime();

    public native int getHour();

    public native int getMinute();

    public native int getSecond();

    public native int getNano();

    @Override
    public native LocalDateTime with(TemporalAdjuster var1);

    @Override
    public native LocalDateTime with(TemporalField var1, long var2);

    public native LocalDateTime withYear(int var1);

    public native LocalDateTime withMonth(int var1);

    public native LocalDateTime withDayOfMonth(int var1);

    public native LocalDateTime withDayOfYear(int var1);

    public native LocalDateTime withHour(int var1);

    public native LocalDateTime withMinute(int var1);

    public native LocalDateTime withSecond(int var1);

    public native LocalDateTime withNano(int var1);

    public native LocalDateTime truncatedTo(TemporalUnit var1);

    @Override
    public native LocalDateTime plus(TemporalAmount var1);

    @Override
    public native LocalDateTime plus(long var1, TemporalUnit var3);

    public native LocalDateTime plusYears(long var1);

    public native LocalDateTime plusMonths(long var1);

    public native LocalDateTime plusWeeks(long var1);

    public native LocalDateTime plusDays(long var1);

    public native LocalDateTime plusHours(long var1);

    public native LocalDateTime plusMinutes(long var1);

    public native LocalDateTime plusSeconds(long var1);

    public native LocalDateTime plusNanos(long var1);

    @Override
    public native LocalDateTime minus(TemporalAmount var1);

    @Override
    public native LocalDateTime minus(long var1, TemporalUnit var3);

    public native LocalDateTime minusYears(long var1);

    public native LocalDateTime minusMonths(long var1);

    public native LocalDateTime minusWeeks(long var1);

    public native LocalDateTime minusDays(long var1);

    public native LocalDateTime minusHours(long var1);

    public native LocalDateTime minusMinutes(long var1);

    public native LocalDateTime minusSeconds(long var1);

    public native LocalDateTime minusNanos(long var1);

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native Temporal adjustInto(Temporal var1);

    @Override
    public native long until(Temporal var1, TemporalUnit var2);

    @Override
    public native String format(DateTimeFormatter var1);

    public native OffsetDateTime atOffset(ZoneOffset var1);

    public native ZonedDateTime atZone(ZoneId var1);

    @Override
    public native int compareTo(ChronoLocalDateTime<?> var1);

    @Override
    public native boolean isAfter(ChronoLocalDateTime<?> var1);

    @Override
    public native boolean isBefore(ChronoLocalDateTime<?> var1);

    @Override
    public native boolean isEqual(ChronoLocalDateTime<?> var1);

    @Override
    public native boolean equals(Object var1);

    @Override
    public native int hashCode();

    @Override
    public native String toString();
}

