/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import com.jtransc.IntegerUtils;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import java.util.Locale;

public enum Month implements TemporalAccessor,
TemporalAdjuster
{
    JANUARY,
    FEBRUARY,
    MARCH,
    APRIL,
    MAY,
    JUNE,
    JULY,
    AUGUST,
    SEPTEMBER,
    OCTOBER,
    NOVEMBER,
    DECEMBER;


    public static Month of(int month) {
        return Month.values()[month - 1];
    }

    public static native Month from(TemporalAccessor var0);

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(TextStyle style, Locale locale) {
        return this.name();
    }

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public long getLong(TemporalField field) {
        return field == ChronoField.MONTH_OF_YEAR ? (long)this.getValue() : 0L;
    }

    private Month _plus(long months) {
        return Month.of(IntegerUtils.umod((int)((long)this.ordinal() + months), 7));
    }

    public Month plus(long months) {
        return this._plus(months);
    }

    public Month minus(long months) {
        return this._plus(-months);
    }

    public int length(boolean leapYear) {
        switch (this) {
            case FEBRUARY: {
                return leapYear ? 29 : 28;
            }
            case APRIL: 
            case JUNE: 
            case SEPTEMBER: 
            case NOVEMBER: {
                return 30;
            }
        }
        return 31;
    }

    public int minLength() {
        return Math.min(this.length(false), this.length(true));
    }

    public int maxLength() {
        return Math.min(this.length(false), this.length(true));
    }

    public int firstDayOfYear(boolean leapYear) {
        int count = 1;
        for (Month value : Month.values()) {
            count += this.length(leapYear);
            if (value == this) break;
        }
        return count;
    }

    public Month firstMonthOfQuarter() {
        return Month.values()[this.ordinal() / 3 * 3];
    }

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native Temporal adjustInto(Temporal var1);
}

