/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAccessor;
import java.time.zone.ZoneRules;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class ZoneId
implements Serializable {
    public static final Map<String, String> SHORT_IDS = new HashMap<String, String>(64){
        {
            this.put("ACT", "Australia/Darwin");
            this.put("AET", "Australia/Sydney");
            this.put("AGT", "America/Argentina/Buenos_Aires");
            this.put("ART", "Africa/Cairo");
            this.put("AST", "America/Anchorage");
            this.put("BET", "America/Sao_Paulo");
            this.put("BST", "Asia/Dhaka");
            this.put("CAT", "Africa/Harare");
            this.put("CNT", "America/St_Johns");
            this.put("CST", "America/Chicago");
            this.put("CTT", "Asia/Shanghai");
            this.put("EAT", "Africa/Addis_Ababa");
            this.put("ECT", "Europe/Paris");
            this.put("IET", "America/Indiana/Indianapolis");
            this.put("IST", "Asia/Kolkata");
            this.put("JST", "Asia/Tokyo");
            this.put("MIT", "Pacific/Apia");
            this.put("NET", "Asia/Yerevan");
            this.put("NST", "Pacific/Auckland");
            this.put("PLT", "Asia/Karachi");
            this.put("PNT", "America/Phoenix");
            this.put("PRT", "America/Puerto_Rico");
            this.put("PST", "America/Los_Angeles");
            this.put("SST", "Pacific/Guadalcanal");
            this.put("VST", "Asia/Ho_Chi_Minh");
            this.put("EST", "-05:00");
            this.put("MST", "-07:00");
            this.put("HST", "-10:00");
        }
    };

    ZoneId() {
    }

    public static ZoneId systemDefault() {
        return ZoneOffset.UTC;
    }

    public static Set<String> getAvailableZoneIds() {
        return SHORT_IDS.keySet();
    }

    public static ZoneId of(String zoneId, Map<String, String> aliasMap) {
        return ZoneOffset.UTC;
    }

    public static ZoneId of(String zoneId) {
        return ZoneOffset.UTC;
    }

    public static ZoneId ofOffset(String prefix, ZoneOffset offset) {
        return ZoneOffset.UTC;
    }

    public static ZoneId from(TemporalAccessor temporal) {
        return ZoneOffset.UTC;
    }

    public abstract String getId();

    public String getDisplayName(TextStyle style, Locale locale) {
        return this.getId();
    }

    public abstract ZoneRules getRules();

    public ZoneId normalized() {
        return this;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }
}

