/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;

public final class ZoneOffset
extends ZoneId
implements TemporalAccessor,
TemporalAdjuster,
Comparable<ZoneOffset>,
Serializable {
    public static final ZoneOffset UTC = new ZoneOffset(0);
    public static final ZoneOffset MIN = new ZoneOffset(-64800);
    public static final ZoneOffset MAX = new ZoneOffset(64800);
    private final int totalSeconds;

    private ZoneOffset(int totalSeconds) {
        this.totalSeconds = totalSeconds;
    }

    private static ZoneOffset _of(int totalHours, int totalMinutes, int totalSeconds) {
        int finalSeconds = totalHours * 3600 + totalMinutes * 60 + totalSeconds;
        switch (finalSeconds) {
            case 0: {
                return UTC;
            }
        }
        return new ZoneOffset(finalSeconds);
    }

    public static ZoneOffset of(String offsetId) {
        return UTC;
    }

    public static ZoneOffset ofHours(int hours) {
        return ZoneOffset._of(hours, 0, 0);
    }

    public static ZoneOffset ofHoursMinutes(int hours, int minutes) {
        return ZoneOffset._of(hours, minutes % 60, 0);
    }

    public static ZoneOffset ofHoursMinutesSeconds(int hours, int minutes, int seconds) {
        return ZoneOffset._of(hours, minutes % 60, seconds % 60);
    }

    public static ZoneOffset ofTotalSeconds(int totalSeconds) {
        return ZoneOffset._of(0, 0, totalSeconds);
    }

    public static native ZoneOffset from(TemporalAccessor var0);

    public int getTotalSeconds() {
        return this.totalSeconds;
    }

    @Override
    public String getId() {
        return "UTC";
    }

    @Override
    public native ZoneRules getRules();

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public native int get(TemporalField var1);

    @Override
    public native long getLong(TemporalField var1);

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native Temporal adjustInto(Temporal var1);

    native void write(DataOutput var1) throws IOException;

    @Override
    public native int compareTo(ZoneOffset var1);

    @Override
    public native boolean equals(Object var1);

    @Override
    public native int hashCode();

    @Override
    public native String toString();
}

