/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;

public final class ZonedDateTime
implements Temporal,
ChronoZonedDateTime<LocalDate>,
Serializable {
    private final LocalDateTime dateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;

    private ZonedDateTime(LocalDateTime dateTime, ZoneOffset offset, ZoneId zone) {
        this.dateTime = dateTime;
        this.offset = offset;
        this.zone = zone;
    }

    public static native ZonedDateTime now();

    public static native ZonedDateTime now(ZoneId var0);

    public static native ZonedDateTime now(Clock var0);

    public static native ZonedDateTime of(LocalDate var0, LocalTime var1, ZoneId var2);

    public static native ZonedDateTime of(LocalDateTime var0, ZoneId var1);

    public static native ZonedDateTime of(int var0, int var1, int var2, int var3, int var4, int var5, int var6, ZoneId var7);

    public static native ZonedDateTime ofLocal(LocalDateTime var0, ZoneId var1, ZoneOffset var2);

    public static native ZonedDateTime ofInstant(Instant var0, ZoneId var1);

    public static native ZonedDateTime ofInstant(LocalDateTime var0, ZoneOffset var1, ZoneId var2);

    public static native ZonedDateTime ofStrict(LocalDateTime var0, ZoneOffset var1, ZoneId var2);

    public static native ZonedDateTime from(TemporalAccessor var0);

    public static native ZonedDateTime parse(CharSequence var0);

    public static native ZonedDateTime parse(CharSequence var0, DateTimeFormatter var1);

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native boolean isSupported(TemporalUnit var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public native int get(TemporalField var1);

    @Override
    public native long getLong(TemporalField var1);

    @Override
    public native ZoneOffset getOffset();

    public native ZonedDateTime withEarlierOffsetAtOverlap();

    public native ZonedDateTime withLaterOffsetAtOverlap();

    @Override
    public native ZoneId getZone();

    public native ZonedDateTime withZoneSameLocal(ZoneId var1);

    public native ZonedDateTime withZoneSameInstant(ZoneId var1);

    public native ZonedDateTime withFixedOffsetZone();

    public native LocalDateTime toLocalDateTime();

    @Override
    public native LocalDate toLocalDate();

    public native int getYear();

    public native int getMonthValue();

    public native Month getMonth();

    public native int getDayOfMonth();

    public native int getDayOfYear();

    public native DayOfWeek getDayOfWeek();

    @Override
    public native LocalTime toLocalTime();

    public native int getHour();

    public native int getMinute();

    public native int getSecond();

    public native int getNano();

    @Override
    public native ZonedDateTime with(TemporalAdjuster var1);

    @Override
    public native ZonedDateTime with(TemporalField var1, long var2);

    public native ZonedDateTime withYear(int var1);

    public native ZonedDateTime withMonth(int var1);

    public native ZonedDateTime withDayOfMonth(int var1);

    public native ZonedDateTime withDayOfYear(int var1);

    public native ZonedDateTime withHour(int var1);

    public native ZonedDateTime withMinute(int var1);

    public native ZonedDateTime withSecond(int var1);

    public native ZonedDateTime withNano(int var1);

    public native ZonedDateTime truncatedTo(TemporalUnit var1);

    @Override
    public native ZonedDateTime plus(TemporalAmount var1);

    @Override
    public native ZonedDateTime plus(long var1, TemporalUnit var3);

    public native ZonedDateTime plusYears(long var1);

    public native ZonedDateTime plusMonths(long var1);

    public native ZonedDateTime plusWeeks(long var1);

    public native ZonedDateTime plusDays(long var1);

    public native ZonedDateTime plusHours(long var1);

    public native ZonedDateTime plusMinutes(long var1);

    public native ZonedDateTime plusSeconds(long var1);

    public native ZonedDateTime plusNanos(long var1);

    @Override
    public native ZonedDateTime minus(TemporalAmount var1);

    @Override
    public native ZonedDateTime minus(long var1, TemporalUnit var3);

    public native ZonedDateTime minusYears(long var1);

    public native ZonedDateTime minusMonths(long var1);

    public native ZonedDateTime minusWeeks(long var1);

    public native ZonedDateTime minusDays(long var1);

    public native ZonedDateTime minusHours(long var1);

    public native ZonedDateTime minusMinutes(long var1);

    public native ZonedDateTime minusSeconds(long var1);

    public native ZonedDateTime minusNanos(long var1);

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native long until(Temporal var1, TemporalUnit var2);

    @Override
    public native String format(DateTimeFormatter var1);

    public native OffsetDateTime toOffsetDateTime();

    @Override
    public native boolean equals(Object var1);

    @Override
    public native int hashCode();

    @Override
    public native String toString();
}

