/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.io.Serializable;
import java.time.temporal.TemporalField;

public final class ValueRange
implements Serializable {
    private final long minSmallest;
    private final long minLargest;
    private final long maxSmallest;
    private final long maxLargest;

    public static ValueRange of(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException();
        }
        return new ValueRange(min, min, max, max);
    }

    public static ValueRange of(long min, long maxSmallest, long maxLargest) {
        return ValueRange.of(min, min, maxSmallest, maxLargest);
    }

    public static ValueRange of(long minSmallest, long minLargest, long maxSmallest, long maxLargest) {
        if (minSmallest > minLargest || maxSmallest > maxLargest || minLargest > maxLargest) {
            throw new IllegalArgumentException();
        }
        return new ValueRange(minSmallest, minLargest, maxSmallest, maxLargest);
    }

    private ValueRange(long minSmallest, long minLargest, long maxSmallest, long maxLargest) {
        this.minSmallest = minSmallest;
        this.minLargest = minLargest;
        this.maxSmallest = maxSmallest;
        this.maxLargest = maxLargest;
    }

    public boolean isFixed() {
        return this.minSmallest == this.minLargest && this.maxSmallest == this.maxLargest;
    }

    public long getMinimum() {
        return this.minSmallest;
    }

    public long getLargestMinimum() {
        return this.minLargest;
    }

    public long getSmallestMaximum() {
        return this.maxSmallest;
    }

    public long getMaximum() {
        return this.maxLargest;
    }

    public boolean isIntValue() {
        return this.getMinimum() >= Integer.MIN_VALUE && this.getMaximum() <= Integer.MAX_VALUE;
    }

    public boolean isValidValue(long value) {
        return value >= this.getMinimum() && value <= this.getMaximum();
    }

    public boolean isValidIntValue(long value) {
        return this.isIntValue() && this.isValidValue(value);
    }

    public native long checkValidValue(long var1, TemporalField var3);

    public native int checkValidIntValue(long var1, TemporalField var3);

    public native boolean equals(Object var1);

    public native int hashCode();

    public native String toString();
}

