/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.JTranscSystem;
import com.jtransc.internal.JTranscCType;
import com.jtransc.text.JTranscLocale;
import com.jtransc.util.JTranscStrings;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;

public class Formatter
implements Closeable,
Flushable {
    private final Appendable out;
    private IOException ioException;
    private final Locale l;

    public Formatter(Appendable a, Locale l) {
        this.out = a;
        this.l = l;
    }

    public Formatter() {
        this(new StringBuilder(), Locale.getDefault());
    }

    public Formatter(Appendable a) {
        this(a, Locale.getDefault());
    }

    public Formatter(Locale l) {
        this(new StringBuilder(), l);
    }

    public Formatter(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public Formatter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn);
    }

    public Formatter(String fileName, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(fileName), csn, l);
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public Formatter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), csn)));
    }

    public Formatter(File file, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), csn)), l);
    }

    public Formatter(OutputStream os) {
        this(new BufferedWriter(new OutputStreamWriter(os, Charset.defaultCharset())));
    }

    public Formatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(os, csn, Locale.getDefault());
    }

    public Formatter(OutputStream os, String csn, Locale l) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(os, csn)));
    }

    public Formatter(PrintStream ps) {
        this(ps, Locale.getDefault());
    }

    @Override
    public void close() {
        if (this.out instanceof Closeable) {
            try {
                ((Closeable)((Object)this.out)).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void flush() {
        if (this.out instanceof Flushable) {
            try {
                ((Flushable)((Object)this.out)).flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Locale locale() {
        return Locale.getDefault();
    }

    public Appendable out() {
        return this.out;
    }

    public IOException ioException() {
        return this.ioException;
    }

    public Formatter format(String format, Object ... args) {
        this.doFormat(format, args);
        return this;
    }

    public Formatter format(Locale l, String format, Object ... args) {
        this.doFormat(format, args);
        return this;
    }

    private void doFormat(String format, Object ... args) {
        try {
            this.doFormat0(format, args);
        }
        catch (IOException t) {
            this.ioException = t;
        }
    }

    private void doFormat0(String format, Object ... args) throws IOException {
        int n = 0;
        int argn = 0;
        int len = format.length();
        block0: while (n < len) {
            char c;
            if ((c = format.charAt(n++)) == '%') {
                char cc;
                char pad = ' ';
                boolean step = false;
                boolean right = false;
                boolean readingDecimals = false;
                int width = 0;
                int decimalWidth = 0;
                while (true) {
                    if ((cc = format.charAt(n++)) == '%') {
                        this.out.append('%');
                        continue block0;
                    }
                    if (cc == '-') {
                        right = true;
                        continue;
                    }
                    if (!step && cc == '0') {
                        pad = '0';
                        step = true;
                        continue;
                    }
                    if (cc >= '0' && cc <= '9') {
                        if (readingDecimals) {
                            decimalWidth *= 10;
                            decimalWidth += JTranscCType.decodeDigit((char)cc);
                            continue;
                        }
                        width *= 10;
                        width += JTranscCType.decodeDigit((char)cc);
                        continue;
                    }
                    if (cc != '.') break;
                    readingDecimals = true;
                }
                if (cc == 'n') {
                    this.out.append(JTranscSystem.lineSeparator());
                    continue;
                }
                this.out.append(this.formatValue(right, width, decimalWidth, pad, cc, args[argn++]));
                continue;
            }
            this.out.append(c);
        }
    }

    private String doNormalPad(String str, boolean right, int width, char pad) {
        if (width <= 0) {
            return str;
        }
        while (str.length() < width) {
            if (right) {
                str = "" + str + pad;
                continue;
            }
            str = "" + pad + str;
        }
        return str;
    }

    private String doDecimalPad(String str, int width) {
        if (str.length() > width) {
            return str.substring(0, width);
        }
        StringBuilder out = new StringBuilder(str);
        while (out.length() < width) {
            out.append('0');
        }
        return out.toString();
    }

    private String formatValue(boolean right, int width, int decimalWidth, char pad, char c, Object value) {
        switch (c) {
            case 'X': 
            case 'x': {
                String out = value instanceof Long ? "" + Long.toUnsignedString((Long)value, 16) : "" + Integer.toUnsignedString((Integer)value, 16);
                if (c == 'X') {
                    out = out.toUpperCase();
                }
                return this.doNormalPad(out, right, width, pad);
            }
            case 'f': {
                double v = ((Number)value).doubleValue();
                String[] parts = JTranscStrings.split((String)String.valueOf(v), (char)'.');
                if (parts.length <= 0) {
                    return "";
                }
                if (parts.length <= 1) {
                    return parts[0];
                }
                String integral = this.doNormalPad(parts[0], right, width, pad);
                String decimal = this.doDecimalPad(parts[1], decimalWidth);
                if (decimal.length() == 0) {
                    return integral;
                }
                return integral + JTranscLocale.getDecimalSeparator((Locale)this.l) + decimal;
            }
        }
        return this.doNormalPad(String.valueOf(value), right, width, pad);
    }

    public String toString() {
        return this.out.toString();
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }
}

