/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.jtransc.JTranscSystemProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Objects;

public final class Locale
implements Cloneable,
Serializable {
    public static final Locale CANADA = new Locale(true, "en", "CA");
    public static final Locale CANADA_FRENCH = new Locale(true, "fr", "CA");
    public static final Locale CHINA = new Locale(true, "zh", "CN");
    public static final Locale CHINESE = new Locale(true, "zh", "");
    public static final Locale ENGLISH = new Locale(true, "en", "");
    public static final Locale FRANCE = new Locale(true, "fr", "FR");
    public static final Locale FRENCH = new Locale(true, "fr", "");
    public static final Locale GERMAN = new Locale(true, "de", "");
    public static final Locale GERMANY = new Locale(true, "de", "DE");
    public static final Locale ITALIAN = new Locale(true, "it", "");
    public static final Locale ITALY = new Locale(true, "it", "IT");
    public static final Locale JAPAN = new Locale(true, "ja", "JP");
    public static final Locale JAPANESE = new Locale(true, "ja", "");
    public static final Locale KOREA = new Locale(true, "ko", "KR");
    public static final Locale KOREAN = new Locale(true, "ko", "");
    public static final Locale PRC = new Locale(true, "zh", "CN");
    public static final Locale ROOT = new Locale(true, "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale(true, "zh", "CN");
    public static final Locale TAIWAN = new Locale(true, "zh", "TW");
    public static final Locale TRADITIONAL_CHINESE = new Locale(true, "zh", "TW");
    public static final Locale UK = new Locale(true, "en", "GB");
    public static final Locale US = new Locale(true, "en", "US");
    private static final Locale SPANISH = new Locale(true, "es", "ES");
    private static Locale defaultLocale = US;
    private transient String countryCode;
    private transient String languageCode;
    private transient String variantCode;
    private transient String cachedToStringResult;
    private static Locale[] AVAILABLE_LOCALES;
    private static final ObjectStreamField[] serialPersistentFields;

    public static Locale forLanguageTag(String languageTag) {
        String[] parts = languageTag.split("-");
        String language = parts[0].toLowerCase();
        for (Locale locale : Locale.getAvailableLocales()) {
            if (!Objects.equals(locale.getLanguage(), language)) continue;
            return locale;
        }
        return new Locale(true, language, "");
    }

    private Locale(boolean unused, String lowerCaseLanguageCode, String upperCaseCountryCode) {
        this.languageCode = lowerCaseLanguageCode;
        this.countryCode = upperCaseCountryCode;
        this.variantCode = "";
    }

    public Locale(String language) {
        this(language, "", "");
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language, String country, String variant) {
        Objects.requireNonNull(language);
        Objects.requireNonNull(country);
        Objects.requireNonNull(variant);
        if (language.isEmpty() && country.isEmpty()) {
            this.languageCode = "";
            this.countryCode = "";
            this.variantCode = variant;
            return;
        }
        this.languageCode = language.toLowerCase(US);
        if (this.languageCode.equals("he")) {
            this.languageCode = "iw";
        } else if (this.languageCode.equals("id")) {
            this.languageCode = "in";
        } else if (this.languageCode.equals("yi")) {
            this.languageCode = "ji";
        }
        this.countryCode = country.toUpperCase(US);
        this.variantCode = variant;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Locale) {
            Locale o = (Locale)object;
            return this.languageCode.equals(o.languageCode) && this.countryCode.equals(o.countryCode) && this.variantCode.equals(o.variantCode);
        }
        return false;
    }

    public static Locale[] getAvailableLocales() {
        return AVAILABLE_LOCALES;
    }

    public String getCountry() {
        return this.countryCode;
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public static Locale getDefault(Category category) {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        if (this.countryCode.isEmpty()) {
            return "";
        }
        return locale.countryCode;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        if (this.languageCode.isEmpty()) {
            return "";
        }
        String localeString = this.toString();
        if (this.languageCode.equals("tl")) {
            localeString = Locale.toNewString("fil", this.countryCode, this.variantCode);
        }
        return this.languageCode;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        if (!this.languageCode.isEmpty()) {
            String displayLanguage = this.getDisplayLanguage(locale);
            buffer.append(displayLanguage.isEmpty() ? this.languageCode : displayLanguage);
            ++count;
        }
        if (!this.countryCode.isEmpty()) {
            String displayCountry;
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append((displayCountry = this.getDisplayCountry(locale)).isEmpty() ? this.countryCode : displayCountry);
            ++count;
        }
        if (!this.variantCode.isEmpty()) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2) {
                buffer.append(",");
            }
            String displayVariant = this.getDisplayVariant(locale);
            buffer.append(displayVariant.isEmpty() ? this.variantCode : displayVariant);
            ++count;
        }
        if (count > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        if (this.variantCode.length() == 0) {
            return this.variantCode;
        }
        return this.variantCode;
    }

    public String getISO3Country() {
        return "USA";
    }

    public String getISO3Language() {
        return "ENG";
    }

    public static String[] getISOCountries() {
        return new String[]{"USA"};
    }

    public static String[] getISOLanguages() {
        return new String[]{"ENG"};
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String getVariant() {
        return this.variantCode;
    }

    public synchronized int hashCode() {
        return this.countryCode.hashCode() + this.languageCode.hashCode() + this.variantCode.hashCode();
    }

    public static synchronized void setDefault(Locale locale) {
        Objects.requireNonNull(locale);
        defaultLocale = locale;
    }

    public final String toString() {
        String result = this.cachedToStringResult;
        if (result == null) {
            result = this.cachedToStringResult = Locale.toNewString(this.languageCode, this.countryCode, this.variantCode);
        }
        return result;
    }

    private static String toNewString(String languageCode, String countryCode, String variantCode) {
        if (languageCode.length() == 0 && countryCode.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(11);
        result.append(languageCode);
        if (countryCode.length() > 0 || variantCode.length() > 0) {
            result.append('_');
        }
        result.append(countryCode);
        if (variantCode.length() > 0) {
            result.append('_');
        }
        result.append(variantCode);
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("country", this.countryCode);
        fields.put("hashcode", -1);
        fields.put("language", this.languageCode);
        fields.put("variant", this.variantCode);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.countryCode = (String)fields.get("country", "");
        this.languageCode = (String)fields.get("language", "");
        this.variantCode = (String)fields.get("variant", "");
    }

    static {
        String language = JTranscSystemProperties.userLanguage();
        String region = JTranscSystemProperties.userRegion();
        String variant = JTranscSystemProperties.userVariant();
        defaultLocale = new Locale(language, region, variant);
        AVAILABLE_LOCALES = new Locale[]{ENGLISH, SPANISH, FRENCH, GERMAN, ITALY};
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("country", String.class), new ObjectStreamField("hashcode", Integer.TYPE), new ObjectStreamField("language", String.class), new ObjectStreamField("variant", String.class)};
    }

    public static enum Category {
        DISPLAY,
        FORMAT;

    }
}

