/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Optional<T> {
    private static Optional<?> CACHED_EMPTY;
    private final T v;

    private Optional(T value) {
        this.v = value;
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        return value != null ? Optional.of(value) : Optional.empty();
    }

    public static <T> Optional<T> empty() {
        if (CACHED_EMPTY == null) {
            CACHED_EMPTY = new Optional<Object>(null);
        }
        return CACHED_EMPTY;
    }

    public boolean isPresent() {
        return this.v != null;
    }

    public T get() {
        if (this.v == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.v;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.v != null) {
            consumer.accept(this.v);
        }
    }

    public T orElse(T defaultValue) {
        return this.v != null ? this.v : defaultValue;
    }

    public T orElseGet(Supplier<? extends T> defaultSupplier) {
        return this.v != null ? this.v : defaultSupplier.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> throwSupplier) throws X {
        return (T)(this.v != null ? this.v : throwSupplier.get());
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.isPresent() ? Optional.ofNullable(mapper.apply(this.v)) : Optional.empty();
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> isPresentMapper) {
        return this.isPresent() ? Objects.requireNonNull(isPresentMapper.apply(this.v)) : Optional.empty();
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        return this.isPresent() ? (predicate.test(this.v) ? this : Optional.empty()) : this;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof Optional && Objects.equals(this.v, ((Optional)that).v);
    }

    public int hashCode() {
        return Objects.hashCode(this.v);
    }

    public String toString() {
        return this.v != null ? "Optional[" + this.v + "]" : "Optional.empty";
    }
}

