/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.charset.charsets;

import com.jtransc.JTranscBits;
import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.charset.JTranscCharBuffer;
import com.jtransc.charset.JTranscCharset;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

abstract class JTranscCharsetUTF16Base
extends JTranscCharset {
    private String[] aliases;
    private boolean littleEndian;

    @JTranscSync
    public JTranscCharsetUTF16Base(String[] names, boolean littleEndian) {
        super(names, 2, 2.0f, 2);
        this.littleEndian = littleEndian;
    }

    @JTranscSync
    public void encode(char[] in, int offset, int len, ByteArrayOutputStream out) {
        for (int n = 0; n < len; ++n) {
            char c = in[offset + n];
            if (this.littleEndian) {
                out.write(c & 0xFF);
                out.write(c >>> 8 & 0xFF);
                continue;
            }
            out.write(c >>> 8 & 0xFF);
            out.write(c & 0xFF);
        }
    }

    @JTranscSync
    public void decode(byte[] in, int offset, int len, JTranscCharBuffer out) {
        for (int n = 0; n < len; n += 2) {
            out.append((char)JTranscBits.readInt16((byte[])in, (int)(offset + n), (boolean)this.littleEndian));
        }
    }

    @JTranscAsync
    public void decode(ByteBuffer in, CharBuffer out) {
        for (int n = 0; n < in.remaining() && out.hasRemaining(); n += 2) {
            out.append((char)JTranscBits.readInt16((ByteBuffer)in, (boolean)this.littleEndian));
        }
    }
}

