/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscSync;
import java.io.Serializable;

public final class Boolean
implements Serializable,
Comparable<Boolean> {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = Class.getPrimitiveClass("boolean");
    private final boolean value;

    @JTranscSync
    public Boolean(boolean value) {
        this.value = value;
    }

    @JTranscSync
    public Boolean(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    @JTranscSync
    public static boolean parseBoolean(String value) {
        return value != null && value.compareToIgnoreCase("true") == 0;
    }

    @JTranscSync
    public boolean booleanValue() {
        return this.value;
    }

    @JTranscSync
    public static Boolean valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    @JTranscSync
    public static Boolean valueOf(String value) {
        return Boolean.parseBoolean(value);
    }

    @JTranscSync
    public static String toString(boolean value) {
        return value ? "true" : "false";
    }

    @JTranscSync
    public String toString() {
        return Boolean.toString(this.value);
    }

    @JTranscSync
    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @JTranscSync
    public static int hashCode(boolean value) {
        return value ? 1 : 0;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.value == ((Boolean)that).value;
    }

    public static boolean getBoolean(String name) {
        return Boolean.parseBoolean(System.getProperty(name));
    }

    @Override
    @JTranscSync
    public int compareTo(Boolean that) {
        return that != null ? Boolean.compare(this.value, that.value) : Boolean.compare(this.value, false);
    }

    @JTranscSync
    @JTranscMethodBody(target="js", value={"return (p0 == p1) ? 0 : ((!p0) ? -1 : +1);"})
    public static int compare(boolean l, boolean r) {
        return l == r ? 0 : (!l ? -1 : 1);
    }

    @JTranscSync
    public static boolean logicalAnd(boolean l, boolean r) {
        return l & r;
    }

    @JTranscSync
    public static boolean logicalOr(boolean l, boolean r) {
        return l | r;
    }

    @JTranscSync
    public static boolean logicalXor(boolean l, boolean r) {
        return l ^ r;
    }
}

