/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.text.JTranscStringTools;

public final class Float
extends Number
implements Comparable<Float> {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_NORMAL = 1.1754944E-38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final int MAX_EXPONENT = 127;
    public static final int MIN_EXPONENT = -126;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    public static final Class<Float> TYPE = Class.getPrimitiveClass("float");
    private final float value;

    @JTranscSync
    public static float parseFloat(String value) throws NumberFormatException {
        return (float)Double.parseDouble(value);
    }

    @JTranscSync
    public static String toString(float v) {
        return JTranscStringTools.toString((float)v);
    }

    @JTranscSync
    public static String toHexString(float value) {
        return Double.toHexString(value);
    }

    @JTranscSync
    public static Float valueOf(String value) throws NumberFormatException {
        return Float.valueOf(Float.parseFloat(value));
    }

    @JTranscKeep
    @JTranscSync
    public static Float valueOf(float value) {
        return new Float(value);
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="cpp", value={"return std::isnan(p0);"}), @JTranscMethodBody(target="d", value={"return std.math.isNaN(p0);"}), @JTranscMethodBody(target="cs", value={"return Single.IsNaN(p0);"})})
    @JTranscSync
    public static boolean isNaN(float value) {
        return Double.isNaN(value);
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="cpp", value={"return std::isfinite(p0);"}), @JTranscMethodBody(target="d", value={"return to!bool(std.math.isFinite(p0));"}), @JTranscMethodBody(target="cs", value={"return !float.IsNaN(p0) && !float.IsInfinity(p0);"})})
    @JTranscSync
    private static boolean _isFinite(float v) {
        return Double.isFinite(v);
    }

    @JTranscSync
    public static boolean isInfinite(float v) {
        return !Float.isNaN(v) && !Float._isFinite(v);
    }

    @JTranscSync
    public static boolean isFinite(float d) {
        return Float._isFinite(d);
    }

    @JTranscSync
    public Float(float value) {
        this.value = value;
    }

    @JTranscSync
    public Float(double value) {
        this.value = (float)value;
    }

    @JTranscSync
    public Float(String s) throws NumberFormatException {
        this.value = Float.parseFloat(s);
    }

    @JTranscSync
    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    @JTranscSync
    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    @JTranscSync
    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    @JTranscSync
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    @JTranscSync
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    @JTranscSync
    public int intValue() {
        return (int)this.value;
    }

    @Override
    @JTranscSync
    public long longValue() {
        return (long)this.value;
    }

    @Override
    @JTranscSync
    public float floatValue() {
        return this.value;
    }

    @Override
    @JTranscSync
    public double doubleValue() {
        return this.value;
    }

    @JTranscSync
    public int hashCode() {
        return Float.hashCode(this.value);
    }

    @JTranscSync
    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    @JTranscSync
    public boolean equals(Object obj) {
        return obj instanceof Float && Float.floatToIntBits(((Float)obj).value) == Float.floatToIntBits(this.value);
    }

    @HaxeMethodBody(value="return N.floatToIntBits(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="cpp", value={"return *(int *)&p0;"}), @JTranscMethodBody(target="d", value={"return *cast(int *)&p0;"}), @JTranscMethodBody(target="cs", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="as3", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="dart", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="php", value={"return N::floatToIntBits($p0);"})})
    @JTranscSync
    public static native int floatToIntBits(float var0);

    @HaxeMethodBody(value="return N.floatToIntBits(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="cpp", value={"return *(int *)&p0;"}), @JTranscMethodBody(target="d", value={"return *cast(int *)&p0;"}), @JTranscMethodBody(target="cs", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="as3", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="dart", value={"return N.floatToIntBits(p0);"}), @JTranscMethodBody(target="php", value={"return N::floatToIntBits($p0);"})})
    @JTranscSync
    public static native int floatToRawIntBits(float var0);

    @HaxeMethodBody(value="return N.intBitsToFloat(p0);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.intBitsToFloat(p0);"}), @JTranscMethodBody(target="cpp", value={"return *(float *)&p0;"}), @JTranscMethodBody(target="d", value={"return *cast(float *)&p0;"}), @JTranscMethodBody(target="cs", value={"return N.intBitsToFloat(p0);"}), @JTranscMethodBody(target="as3", value={"return N.intBitsToFloat(p0);"}), @JTranscMethodBody(target="dart", value={"return N.intBitsToFloat(p0);"}), @JTranscMethodBody(target="php", value={"return N::intBitsToFloat($p0);"})})
    @JTranscSync
    public static native float intBitsToFloat(int var0);

    @Override
    @JTranscSync
    public int compareTo(Float that) {
        return Float.compare(this.value, that.value);
    }

    @JTranscSync
    public static int compare(float f1, float f2) {
        int b2;
        if (f1 < f2) {
            return -1;
        }
        if (f1 > f2) {
            return 1;
        }
        int b1 = Float.floatToIntBits(f1);
        return b1 == (b2 = Float.floatToIntBits(f2)) ? 0 : (b1 < b2 ? -1 : 1);
    }

    @JTranscSync
    public static float sum(float l, float r) {
        return l + r;
    }

    @JTranscSync
    public static float max(float l, float r) {
        return Math.max(l, r);
    }

    @JTranscSync
    public static float min(float l, float r) {
        return Math.min(l, r);
    }
}

