/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.internal.JTranscCType;

public final class Long
extends Number
implements Comparable<Long> {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    public static final int BYTES = 8;

    @JTranscSync
    public static String toString(long i, int radix) {
        boolean negative;
        if (i == 0L) {
            return "0";
        }
        if (i == Long.MIN_VALUE) {
            return "-9223372036854775808";
        }
        StringBuilder out = new StringBuilder();
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        while (i != 0L) {
            out.append(JTranscCType.encodeDigit((int)((int)((i % (long)radix + (long)radix) % (long)radix))));
            i /= (long)radix;
        }
        if (negative) {
            out.append("-");
        }
        out.reverse();
        return out.toString();
    }

    @JTranscSync
    public static String toUnsignedString(long i, int radix) {
        if (i == 0L) {
            return "0";
        }
        StringBuilder out = new StringBuilder();
        while (i != 0L) {
            out.append(JTranscCType.encodeDigit((int)((int)Long.remainderUnsigned(i, radix))));
            i = Long.divideUnsigned(i, radix);
        }
        out.reverse();
        return out.toString();
    }

    @JTranscSync
    public static String toHexString(long i) {
        return Long.toUnsignedString(i, 16);
    }

    @JTranscSync
    public static String toOctalString(long i) {
        return Long.toUnsignedString(i, 8);
    }

    @JTranscSync
    public static String toBinaryString(long i) {
        return Long.toUnsignedString(i, 2);
    }

    @JTranscSync
    public static String toUnsignedString(long i) {
        return Long.toUnsignedString(i, 10);
    }

    @JTranscSync
    public static long parseLong(String s, int radix) throws NumberFormatException {
        int n;
        long result = 0L;
        int len = s.length();
        boolean negative = s.charAt(0) == '-';
        int sign = negative ? -1 : 1;
        int n2 = n = negative ? 1 : 0;
        while (n < len) {
            result *= (long)radix;
            result += (long)JTranscCType.decodeDigit((char)s.charAt(n));
            ++n;
        }
        return result * (long)sign;
    }

    @JTranscSync
    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    @JTranscSync
    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    @JTranscSync
    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    @JTranscSync
    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return Long.parseUnsignedLong(s, 10);
    }

    @JTranscSync
    public static Long valueOf(String s) throws NumberFormatException {
        return Long.valueOf(s, 10);
    }

    @JTranscKeep
    @JTranscSync
    public static Long valueOf(long l) {
        return new Long(l);
    }

    @JTranscSync
    public static Long decode(String nm) throws NumberFormatException {
        if (nm.length() == 0) {
            throw new NumberFormatException("Zero length string");
        }
        if (nm.startsWith("-")) {
            return -Long.decode(nm.substring(1)).longValue();
        }
        if (nm.startsWith("+")) {
            return Long.decode(nm.substring(1));
        }
        if (nm.startsWith("0x")) {
            return Long.parseLong(nm.substring(2), 16);
        }
        if (nm.startsWith("0X")) {
            return Long.parseLong(nm.substring(2), 16);
        }
        if (nm.startsWith("#")) {
            return Long.parseLong(nm.substring(1), 16);
        }
        if (nm.startsWith("0")) {
            return Long.parseLong(nm.substring(1), 8);
        }
        return Long.parseLong(nm, 10);
    }

    @JTranscSync
    public Long(long value) {
        this.value = value;
    }

    @JTranscSync
    public Long(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    @Override
    @JTranscSync
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    @JTranscSync
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    @JTranscSync
    public int intValue() {
        return (int)this.value;
    }

    @Override
    @JTranscSync
    public long longValue() {
        return this.value;
    }

    @Override
    @JTranscSync
    public float floatValue() {
        return this.value;
    }

    @Override
    @JTranscSync
    public double doubleValue() {
        return this.value;
    }

    @JTranscSync
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @JTranscSync
    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    @JTranscSync
    public boolean equals(Object obj) {
        return obj instanceof Long && this.value == (Long)obj;
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        return Long.getLong(nm, (Long)val);
    }

    public static Long getLong(String nm, Long val) {
        String out = System.getProperty(nm);
        if (out == null) {
            return val;
        }
        try {
            return Long.decode(nm);
        }
        catch (NumberFormatException e) {
            return val;
        }
    }

    @Override
    @JTranscSync
    public int compareTo(Long anotherLong) {
        return Long.compare(this.value, anotherLong.value);
    }

    @JTranscSync
    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    @JTranscSync
    public static int compareUnsigned(long x, long y) {
        return Long.compare(x ^ Long.MIN_VALUE, y ^ Long.MIN_VALUE);
    }

    @JTranscSync
    public static long divideUnsigned(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            return Long.compareUnsigned(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(Long.compareUnsigned(rem, divisor) >= 0 ? 1 : 0);
    }

    @JTranscSync
    public static long remainderUnsigned(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            return Long.compareUnsigned(dividend, divisor) < 0 ? dividend : dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (Long.compareUnsigned(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    @JTranscSync
    public static long highestOneBit(long v) {
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return v - (v >>> 1);
    }

    @JTranscSync
    public static long lowestOneBit(long v) {
        return v & -v;
    }

    @JTranscSync
    public static int numberOfLeadingZeros(long v) {
        if (v < 0L) {
            return 0;
        }
        if (v == 0L) {
            return 64;
        }
        int n = 1;
        int i = (int)(v >>> 32);
        if (i == 0) {
            n += 32;
            i = (int)v;
        }
        if (i >>> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >>> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >>> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >>> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n - (i >>> 31);
    }

    @JTranscSync
    public static int numberOfTrailingZeros(long v) {
        int low = (int)v;
        return low != 0 ? Integer.numberOfTrailingZeros(low) : 32 + Integer.numberOfTrailingZeros((int)(v >>> 32));
    }

    @JTranscSync
    public static int bitCount(long v) {
        v -= v >>> 1 & 0x5555555555555555L;
        v = (v & 0x3333333333333333L) + (v >>> 2 & 0x3333333333333333L);
        int i = (int)(v >>> 32) + (int)v;
        i = (i & 0xF0F0F0F) + (i >>> 4 & 0xF0F0F0F);
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x7F;
    }

    @JTranscSync
    public static long rotateLeft(long value, int distance) {
        return value << distance | value >>> -distance;
    }

    @JTranscSync
    public static long rotateRight(long value, int distance) {
        return value >>> distance | value << -distance;
    }

    @JTranscSync
    public static long reverse(long v) {
        v = v >>> 1 & 0x5555555555555555L | (v & 0x5555555555555555L) << 1;
        v = v >>> 2 & 0x3333333333333333L | (v & 0x3333333333333333L) << 2;
        v = v >>> 4 & 0xF0F0F0F0F0F0F0FL | (v & 0xF0F0F0F0F0F0F0FL) << 4;
        v = v >>> 8 & 0xFF00FF00FF00FFL | (v & 0xFF00FF00FF00FFL) << 8;
        v = v >>> 16 & 0xFFFF0000FFFFL | (v & 0xFFFF0000FFFFL) << 16;
        return v >>> 32 | v << 32;
    }

    @JTranscSync
    public static int signum(long v) {
        return (int)(v >> 63 | -v >>> 63);
    }

    @JTranscMethodBody(target="cpp", value={"return N::bswap64(p0);"})
    @JTranscSync
    public static long reverseBytes(long v) {
        v = v >>> 8 & 0xFF00FF00FF00FFL | (v & 0xFF00FF00FF00FFL) << 8;
        v = v >>> 16 & 0xFFFF0000FFFFL | (v & 0xFFFF0000FFFFL) << 16;
        return v >>> 32 | v << 32;
    }

    @JTranscSync
    public static long sum(long l, long r) {
        return l + r;
    }

    @JTranscSync
    public static long max(long l, long r) {
        return Math.max(l, r);
    }

    @JTranscSync
    public static long min(long l, long r) {
        return Math.min(l, r);
    }

    @JTranscSync
    public static String toString(long i) {
        return Long.toString(i, 10);
    }

    @JTranscSync
    public String toString() {
        return Long.toString(this.value);
    }
}

