/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscSync;
import java.io.Serializable;
import java.util.Objects;

public final class StackTraceElement
implements Serializable {
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;

    @JTranscSync
    public StackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber) {
        this.declaringClass = declaringClass != null ? declaringClass : "UNKNOWN";
        this.methodName = methodName != null ? methodName : "UNKNOWN";
        this.fileName = fileName != null ? fileName : "UNKNOWN";
        this.lineNumber = lineNumber;
    }

    @JTranscSync
    public String getFileName() {
        return this.fileName;
    }

    @JTranscSync
    public int getLineNumber() {
        return this.lineNumber;
    }

    @JTranscSync
    public String getClassName() {
        return this.declaringClass;
    }

    @JTranscSync
    public String getMethodName() {
        return this.methodName;
    }

    @JTranscSync
    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        return this.getClassName() + "." + this.methodName + (this.isNativeMethod() ? "(Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? "(" + this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "(" + this.fileName + ")" : "(Unknown Source)")));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement e = (StackTraceElement)obj;
        return e.declaringClass.equals(this.declaringClass) && e.lineNumber == this.lineNumber && Objects.equals(this.methodName, e.methodName) && Objects.equals(this.fileName, e.fileName);
    }

    public int hashCode() {
        int result = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        result = 31 * result + Objects.hashCode(this.fileName);
        result = 31 * result + this.lineNumber;
        return result;
    }
}

