/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.JTranscSystem;
import com.jtransc.annotation.JTranscAddIncludes;
import com.jtransc.annotation.JTranscAddIncludesList;
import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscAddMembersList;
import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.haxe.HaxeAddMembers;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JTranscAddMembersList(value={@JTranscAddMembers(target="d", value={"static {% CLASS java.lang.Thread %} _dCurrentThread; Thread thread;"}), @JTranscAddMembers(target="cs", value={"System.Threading.Thread _cs_thread;"}), @JTranscAddMembers(target="cpp", cond="USE_BOOST", value={"boost::thread t_;"}), @JTranscAddMembers(target="cpp", cond="!USE_BOOST", value={"std::thread t_;"}), @JTranscAddMembers(target="cpp", cond="USE_BOOST", value={"static std::map<boost::thread::id, {% CLASS java.lang.Thread %}*> ###_cpp_threads;"}), @JTranscAddMembers(target="cpp", cond="!USE_BOOST", value={"static std::map<std::thread::id, {% CLASS java.lang.Thread %}*> ###_cpp_threads;"})})
@JTranscAddIncludesList(value={@JTranscAddIncludes(target="cpp", cond="USE_BOOST", value={"thread", "map", "boost/thread.hpp", "boost/chrono.hpp"}), @JTranscAddIncludes(target="cpp", value={"thread", "map"})})
@HaxeAddMembers(value={"private static var threadsMap = new haxe.ds.ObjectMap<Dynamic, {% CLASS java.lang.Thread %}>();", "#if cpp var _cpp_thread: cpp.vm.Thread; #end"})
public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static LinkedHashMap<Long, Thread> _threadsById;
    private ThreadGroup group;
    public String name;
    private long stackSize;
    private Runnable target;
    private int priority = 1;
    private int id;
    private static int lastId;
    private UncaughtExceptionHandler uncaughtExceptionHandler = defaultUncaughtExceptionHandler;
    private boolean _isAlive;
    private static final Object staticLock;
    private static ThreadGroup _mainThreadGroup;
    private static Thread _mainThread;
    private boolean _isDaemon = false;
    private ClassLoader classLoader = null;
    public static UncaughtExceptionHandler defaultUncaughtExceptionHandler;

    public static Thread currentThread() {
        Thread.lazyPrepareThread();
        Thread out = Thread._getCurrentThreadOrNull();
        return out != null ? out : _mainThread;
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="d", value={"if (_dCurrentThread is null) {", "\t_dCurrentThread = new {% CLASS java.lang.Thread %}();", "}", "return _dCurrentThread;"}), @JTranscMethodBody(target="cpp", cond="USE_BOOST", value={"return _cpp_threads[boost::this_thread::get_id()];"}), @JTranscMethodBody(target="cpp", value={"return _cpp_threads[std::this_thread::get_id()];"}), @JTranscMethodBody(target="js", value={"{% if IS_JC %}return {% SMETHOD #CLASS:getThreadById %}({{ JC_COMMA }}_jc.threadId);{% else %}return {% SMETHOD #CLASS:getDefaultThread %}();{% end %}"})})
    @HaxeMethodBody(target="cpp", value="return threadsMap.get(cpp.vm.Thread.current().handle);")
    private static Thread _getCurrentThreadOrNull() {
        int n = 0;
        Thread[] threadArray = Thread.getThreadsCopy();
        int n2 = threadArray.length;
        if (n < n2) {
            Thread t = threadArray[n];
            return t;
        }
        return null;
    }

    private static Thread getThreadById(int id) {
        return _threadsById.get(id);
    }

    private static Thread getDefaultThread() {
        Thread.lazyPrepareThread();
        return _mainThread;
    }

    public StackTraceElement[] getStackTrace() {
        return new Throwable().getStackTrace();
    }

    @JTranscMethodBody(target="d", value={"Thread.yield();"})
    public static void yield() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="d", value={"Thread.sleep(dur!(\"msecs\")(p0));"}), @JTranscMethodBody(target="cpp", cond="USE_BOOST", value={"boost::this_thread::sleep_for(boost::chrono::milliseconds(p0));"}), @JTranscMethodBody(target="cpp", value={"std::this_thread::sleep_for(std::chrono::milliseconds(p0));"}), @JTranscMethodBody(target="js", cond="IS_ASYNC", value={"return new Promise((resolve, reject) => { setTimeout(resolve, p0); });"}, async=true)})
    public static void sleep(long millis) throws InterruptedException {
        JTranscSystem.sleep((double)millis);
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="d", value={"Thread.sleep(dur!(\"msecs\")(p0) + dur!(\"nsecs\")(p1));"}), @JTranscMethodBody(target="cpp", cond="USE_BOOST", value={"boost::this_thread::sleep_for(boost::chrono::milliseconds(p0));"}), @JTranscMethodBody(target="cpp", value={"std::this_thread::sleep_for(std::chrono::milliseconds(p0));"})})
    public static void sleep(long millis, int nanos) throws InterruptedException {
        JTranscSystem.sleep((double)millis);
    }

    public Thread() {
        this(null, null, null, 1024L);
    }

    public Thread(Runnable target) {
        this(null, target, null, 1024L);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this(group, target, null, 1024L);
    }

    public Thread(String name) {
        this(null, null, name, 1024L);
    }

    public Thread(ThreadGroup group, String name) {
        this(group, null, name, 1024L);
    }

    public Thread(Runnable target, String name) {
        this(null, target, name, 1024L);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this(group, target, name, 1024L);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long stackSize) {
        this.group = group != null ? group : Thread.currentThread().getThreadGroup();
        this.target = target;
        this.id = lastId++;
        this.name = name != null ? name : "thread-" + this.id++;
        this.stackSize = stackSize;
        this._init();
    }

    @JTranscMethodBody(target="d", value={"this.thread = new Thread(delegate () {", "\t{% METHOD java.lang.Thread:runInternal:()V %}();", "});"})
    private void _init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Thread[] getThreadsCopy() {
        Collection threads = Thread.getThreadSetInternal().values();
        Object object = staticLock;
        synchronized (object) {
            return threads.toArray(new Thread[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lazyPrepareThread() {
        Object object = staticLock;
        synchronized (object) {
            if (_mainThreadGroup == null) {
                _mainThreadGroup = new ThreadGroup("main");
            }
            if (_mainThread == null) {
                _mainThread = new Thread(_mainThreadGroup, "main");
            }
            if (_threadsById == null) {
                _threadsById = new LinkedHashMap();
                _threadsById.put(_mainThread.getId(), _mainThread);
            }
        }
    }

    private static LinkedHashMap<Long, Thread> getThreadSetInternal() {
        Thread.lazyPrepareThread();
        return _threadsById;
    }

    public synchronized void start() {
        this.runInternalPreInit();
        this._start(this.id);
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="d", value={"this.thread.start();"}), @JTranscMethodBody(target="cs", value={"_cs_thread = new System.Threading.Thread(new System.Threading.ThreadStart(delegate() { this{% IMETHOD java.lang.Thread:runInternal:()V %}();  }));", "_cs_thread.Start();"}), @JTranscMethodBody(target="cpp", cond="USE_BOOST", value={"t_ = std::thread(&{% SMETHOD java.lang.Thread:runInternalStatic:(Ljava/lang/Thread;)V %}, this);"}), @JTranscMethodBody(target="cpp", value={"t_ = std::thread(&{% SMETHOD java.lang.Thread:runInternalStatic:(Ljava/lang/Thread;)V %}, this);"}), @JTranscMethodBody(target="js", value={"{% if IS_JC %}this{% IMETHOD java.lang.Thread:runInternal:()V %}({ threadId: p0, global: _jc.global });{% else %}this{% IMETHOD java.lang.Thread:runInternal:()V %}();{% end %}"})})
    @HaxeMethodBody(target="cpp", value="var that = this;cpp.vm.Thread.create(function():Void {\tthat._cpp_thread = cpp.vm.Thread.current();\tthat{% IMETHOD java.lang.Thread:runInternal:()V %}();});")
    @JTranscAsync
    private void _start(int threadId) {
        System.err.println("WARNING: Threads not supported! Executing thread code in the parent's thread!");
        this.runInternal();
    }

    private void runInternal() {
        try {
            this.runInternalInit();
            this.run();
        }
        catch (Throwable t) {
            this.uncaughtExceptionHandler.uncaughtException(this, t);
        }
        finally {
            this.runExit();
        }
    }

    private static void runInternalStatic(Thread thread) {
        thread.runInternal();
    }

    @JTranscMethodBody(target="cpp", value={"GC_init_pre_thread();"})
    private void runInternalPreInitNative() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInternalPreInit() {
        this.runInternalPreInitNative();
        LinkedHashMap<Long, Thread> set = Thread.getThreadSetInternal();
        Object object = staticLock;
        synchronized (object) {
            set.put(this.getId(), this);
            this._isAlive = true;
        }
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="d", value={"_dCurrentThread = this;"}), @JTranscMethodBody(target="cpp", value={"GC_init_thread(); _cpp_threads[t_.get_id()] = this;"})})
    @HaxeMethodBody(target="cpp", value="threadsMap.set(_cpp_thread.handle, this);")
    private void runInternalInit() {
    }

    @JTranscMethodBody(target="cpp", value={"_cpp_threads.erase(t_.get_id()); GC_finish_thread();"})
    @HaxeMethodBody(target="cpp", value="threadsMap.remove(_cpp_thread.handle);")
    private void runInternalExit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExit() {
        LinkedHashMap<Long, Thread> set = Thread.getThreadSetInternal();
        Thread thread = this;
        synchronized (thread) {
            this.runInternalExit();
            set.remove(this.getId());
            this._isAlive = false;
        }
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    @Deprecated
    @JTranscMethodBody(target="d", value={"this.thread.stop();"})
    public final native void stop();

    @Deprecated
    public final synchronized void stop(Throwable obj) {
    }

    public void interrupt() {
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public boolean isInterrupted() {
        return false;
    }

    @Deprecated
    public void destroy() {
    }

    public final boolean isAlive() {
        return this._isAlive;
    }

    @Deprecated
    public final native void suspend();

    @Deprecated
    public final native void resume();

    public final void setPriority(int newPriority) {
        this.priority = newPriority;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final synchronized void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.getThreadsCopy().length;
    }

    public static int enumerate(Thread[] tarray) {
        int n = 0;
        for (Thread thread : Thread.getThreadsCopy()) {
            if (n >= tarray.length) break;
            tarray[n++] = thread;
        }
        return n;
    }

    @Deprecated
    public int countStackFrames() {
        return 0;
    }

    public final synchronized void join(long millis) throws InterruptedException {
        this.join(millis, 0);
    }

    public final synchronized void join(long millis, int nanos) throws InterruptedException {
        long current;
        long elapsed;
        long start = System.currentTimeMillis();
        while (this.isAlive() && (elapsed = (current = System.currentTimeMillis()) - start) < millis) {
            Thread.sleep(1L);
        }
    }

    public final void join() throws InterruptedException {
        while (this.isAlive()) {
            Thread.sleep(1L);
        }
    }

    public static native void dumpStack();

    @JTranscMethodBody(target="d", value={"this.thread.isDaemon = p0;"})
    public final void setDaemon(boolean on) {
        this._isDaemon = on;
    }

    @JTranscMethodBody(target="d", value={"return this.thread.isDaemon;"})
    public final boolean isDaemon() {
        return this._isDaemon;
    }

    public final native void checkAccess();

    public String toString() {
        ThreadGroup group = this.getThreadGroup();
        if (group != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + group.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + ",]";
    }

    public ClassLoader getContextClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = _ClassInternalUtils.getSystemClassLoader();
        }
        return this.classLoader;
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public static boolean holdsLock(Object obj) {
        return false;
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        return new HashMap<Thread, StackTraceElement[]>();
    }

    public long getId() {
        return this.id;
    }

    public State getState() {
        return State.RUNNABLE;
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        defaultUncaughtExceptionHandler = eh;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        this.uncaughtExceptionHandler = eh;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    static {
        lastId = 0;
        staticLock = new Object();
        _mainThreadGroup = null;
        _mainThread = null;
        defaultUncaughtExceptionHandler = (t, e) -> {
            System.out.println(t);
            System.out.println(e);
        };
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }
}

