/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class ThreadGroup
implements Thread.UncaughtExceptionHandler {
    private ThreadGroup parent;
    private String name;
    private LinkedHashSet<Thread> threads;
    private LinkedHashSet<ThreadGroup> children;
    private int maxPriority = 10;
    private boolean isDaemon = false;
    private boolean isDestroyed = false;

    private synchronized Thread[] getThreadsCopy() {
        return this.threads != null ? this.threads.toArray(new Thread[0]) : new Thread[]{};
    }

    private synchronized ArrayList<Thread> getAllThreads(ArrayList<Thread> out) {
        for (Thread thread : this.getThreadsCopy()) {
            out.add(thread);
        }
        for (ThreadGroup group : this.getChildrenCopy()) {
            super.getAllThreads(out);
        }
        return out;
    }

    private synchronized ArrayList<Thread> getAllThreads() {
        return this.getAllThreads(new ArrayList<Thread>());
    }

    private synchronized ThreadGroup[] getChildrenCopy() {
        return this.children != null ? this.children.toArray(new ThreadGroup[0]) : new ThreadGroup[]{};
    }

    private synchronized ArrayList<ThreadGroup> getAllChildren(ArrayList<ThreadGroup> out) {
        out.add(this);
        for (ThreadGroup group : this.getChildrenCopy()) {
            group.getAllChildren(out);
        }
        return out;
    }

    private synchronized ArrayList<ThreadGroup> getAllChildren() {
        return this.getAllChildren(new ArrayList<ThreadGroup>());
    }

    private ThreadGroup() {
        this("ThreadGroup");
    }

    public ThreadGroup(String name) {
        this(null, name);
    }

    public ThreadGroup(ThreadGroup parent, String name) {
        this.parent = parent;
        this.name = name != null ? name : "ThreadGroup";
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getParent() {
        return this.parent;
    }

    public final int getMaxPriority() {
        return this.maxPriority;
    }

    public final boolean isDaemon() {
        return this.isDaemon;
    }

    public synchronized boolean isDestroyed() {
        return this.isDestroyed;
    }

    public final void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }

    public final void setMaxPriority(int priority) {
        this.maxPriority = priority;
    }

    public final boolean parentOf(ThreadGroup g) {
        return g == this.parent || this.parent != null && this.parent.parentOf(g);
    }

    public final void checkAccess() {
    }

    public int activeGroupCount() {
        int count = 1;
        for (ThreadGroup child : this.getChildrenCopy()) {
            count += child.activeGroupCount();
        }
        return count;
    }

    public int activeCount() {
        return this.getAllThreads().size();
    }

    public int enumerate(Thread[] list) {
        return this.enumerate(list, true);
    }

    public int enumerate(ThreadGroup[] list) {
        return this.enumerate(list, true);
    }

    public int enumerate(Thread[] list, boolean recurse) {
        int n = 0;
        for (Thread item : recurse ? this.getAllThreads() : Arrays.asList(this.getThreadsCopy())) {
            if (n >= list.length) break;
            list[n++] = item;
        }
        return n;
    }

    public int enumerate(ThreadGroup[] list, boolean recurse) {
        int n = 0;
        for (ThreadGroup item : recurse ? this.getAllChildren() : Arrays.asList(this.getChildrenCopy())) {
            if (n >= list.length) break;
            list[n++] = item;
        }
        return n;
    }

    @Deprecated
    public final void stop() {
        for (Thread thread : this.getThreadsCopy()) {
            thread.stop();
        }
        for (ThreadGroup group : this.getChildrenCopy()) {
            group.stop();
        }
    }

    public final void interrupt() {
        for (Thread thread : this.getThreadsCopy()) {
            thread.interrupt();
        }
        for (ThreadGroup group : this.getChildrenCopy()) {
            group.interrupt();
        }
    }

    @Deprecated
    public final void suspend() {
        for (Thread thread : this.getThreadsCopy()) {
            thread.suspend();
        }
        for (ThreadGroup group : this.getChildrenCopy()) {
            group.suspend();
        }
    }

    @Deprecated
    public final void resume() {
        for (Thread thread : this.getThreadsCopy()) {
            thread.resume();
        }
        for (ThreadGroup group : this.getChildrenCopy()) {
            group.resume();
        }
    }

    public final synchronized void destroy() {
        this.isDestroyed = true;
        for (Thread thread : this.getThreadsCopy()) {
            thread.destroy();
        }
        for (ThreadGroup group : this.getChildrenCopy()) {
            group.destroy();
        }
    }

    public void list() {
        System.out.println("Unimplemented ThreadGroup.list()");
    }

    @Override
    public native void uncaughtException(Thread var1, Throwable var2);

    @Deprecated
    public boolean allowThreadSuspension(boolean b) {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.getName() + ",maxpri=" + this.getMaxPriority() + "]";
    }
}

