/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.jtransc.annotation.JTranscAddMembers;
import com.jtransc.annotation.JTranscAddMembersList;
import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.io.JTranscConsole;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;

@JTranscAddMembersList(value={@JTranscAddMembers(target="cs", value={"public Exception csException; System.Diagnostics.StackTrace currentStackTrace;"}), @JTranscAddMembers(target="dart", value={"Error dartError; StackTrace currentStackTrace;"})})
public class Throwable
implements Serializable {
    private String message;
    private Throwable cause;
    private boolean enableSuppression = false;
    private boolean writableStackTrace = false;
    private StackTraceElement[] stackTrace;
    private boolean thrown = false;
    private ArrayList<Throwable> supressed;
    private static Throwable[] EMPTY_ARRAY = new Throwable[0];

    @JTranscSync
    public Throwable() {
        this.init(null, null, false, false);
    }

    @JTranscSync
    public Throwable(String message) {
        this.init(message, null, false, false);
    }

    @JTranscSync
    public Throwable(String message, Throwable cause) {
        this.init(message, cause, false, false);
    }

    @JTranscSync
    public Throwable(Throwable cause) {
        this.init(null, cause, false, false);
    }

    @JTranscSync
    protected Throwable(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.init(message, cause, enableSuppression, writableStackTrace);
    }

    @JTranscSync
    private void init(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        this.message = message;
        this.cause = cause;
        this.enableSuppression = enableSuppression;
        this.writableStackTrace = writableStackTrace;
    }

    @JTranscSync
    public String getMessage() {
        return this.message;
    }

    @JTranscSync
    public String getLocalizedMessage() {
        return this.message;
    }

    public synchronized Throwable getCause() {
        return this.cause;
    }

    public synchronized Throwable initCause(Throwable cause) {
        this.cause = cause;
        return this.cause;
    }

    public String toString() {
        return "Exception:" + this.message;
    }

    private StackTraceElement[] getStackTraceLazy() {
        if (this.stackTrace == null) {
            this.fillInStackTrace(0);
        }
        return this.stackTrace;
    }

    public void printStackTrace() {
        JTranscConsole.error((Object)this);
        StackTraceElement[] trace = this.getStackTraceLazy();
        for (StackTraceElement stackTraceElement : trace) {
            JTranscConsole.error((String)("\tat " + stackTraceElement));
        }
        for (Serializable serializable : this.getSuppressed()) {
            JTranscConsole.error((String)"Supressed:");
            ((Throwable)serializable).printStackTrace();
        }
        Throwable ourCause = this.getCause();
        if (ourCause != null) {
            JTranscConsole.error((String)"Cause:");
            ourCause.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        s.println(this);
        StackTraceElement[] trace = this.getStackTraceLazy();
        for (StackTraceElement stackTraceElement : trace) {
            s.println("\tat " + stackTraceElement);
        }
        for (Serializable serializable : this.getSuppressed()) {
            JTranscConsole.error((String)"Supressed:");
            ((Throwable)serializable).printStackTrace(s);
        }
        Throwable ourCause = this.getCause();
        if (ourCause != null) {
            JTranscConsole.error((String)"Cause:");
            ourCause.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        s.println(this);
        StackTraceElement[] trace = this.getStackTraceLazy();
        for (StackTraceElement stackTraceElement : trace) {
            s.println("\tat " + stackTraceElement);
        }
        for (Serializable serializable : this.getSuppressed()) {
            JTranscConsole.error((String)"Supressed:");
            ((Throwable)serializable).printStackTrace(s);
        }
        Throwable ourCause = this.getCause();
        if (ourCause != null) {
            JTranscConsole.error((String)"Cause:");
            ourCause.printStackTrace(s);
        }
    }

    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    private void fillInStackTrace(int dummy) {
        if (this.thrown) {
            this.genStackTraceFromError();
        } else {
            this.genStackTrace();
        }
        this.setStackTrace(this.getStackTraceInternal());
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="dart", value={"this.currentStackTrace = this.dartError.stackTrace;"}), @JTranscMethodBody(target="cs", value={"this.currentStackTrace = new System.Diagnostics.StackTrace(this.csException);"})})
    public void genStackTraceFromError() {
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.error = new Error();"}), @JTranscMethodBody(target="dart", value={"this.currentStackTrace = StackTrace.current;"}), @JTranscMethodBody(target="cs", value={"this.currentStackTrace = new System.Diagnostics.StackTrace();"})})
    public void genStackTrace() {
    }

    @JTranscKeep
    public Throwable prepareThrow() {
        if (!this.thrown) {
            this.init_exception();
        }
        this.thrown = true;
        return this;
    }

    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"this.error = new Error();"}), @JTranscMethodBody(target="dart", value={"this.dartError = new WrappedThrowable(this);"}), @JTranscMethodBody(target="cs", value={"this.csException = new WrappedThrowable(this);"})})
    private void init_exception() {
    }

    @HaxeMethodBody(value="return N.getStackTrace(1);")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return N.getStackTrace(this.error, 0);"}, async=true), @JTranscMethodBody(target="cs", value={"return N.getStackTrace(this.currentStackTrace, 1);"}), @JTranscMethodBody(target="dart", value={"return N.getStackTrace(this.currentStackTrace, 0);"})})
    private StackTraceElement[] getStackTraceInternal() {
        return new StackTraceElement[]{new StackTraceElement("DummyClass", "dummyMethod", "DummyClass.java", 1), new StackTraceElement("DummyClass", "dummyMethod", "DummyClass.java", 1), new StackTraceElement("DummyClass", "dummyMethod", "DummyClass.java", 1)};
    }

    public StackTraceElement[] getStackTrace() {
        this.genStackTrace();
        return (StackTraceElement[])this.getStackTraceLazy().clone();
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = (StackTraceElement[])stackTrace.clone();
    }

    public final synchronized void addSuppressed(Throwable exception) {
        if (this.supressed == null) {
            this.supressed = new ArrayList();
        }
        this.supressed.add(exception);
    }

    public final synchronized Throwable[] getSuppressed() {
        return this.supressed != null ? this.supressed.toArray(EMPTY_ARRAY) : EMPTY_ARRAY;
    }
}

