/*
 * Decompiled with CFR 0.152.
 */
package java.lang.jtransc;

import com.jtransc.annotation.JTranscInline;
import com.jtransc.annotation.JTranscMethodBody;
import com.jtransc.annotation.JTranscMethodBodyList;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.annotation.haxe.HaxeMethodBody;
import com.jtransc.ds.FastIntMap;
import j.ClassInfo;
import j.MemberInfo;
import j.ProgramReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class JTranscCoreReflection {
    private static final FastIntMap<Constructor[]> _constructorsCache = new FastIntMap();
    private static final FastIntMap<Field[]> _fieldsCache = new FastIntMap();
    private static final FastIntMap<Method[]> _methodsCache = new FastIntMap();
    private static final FastIntMap<Annotation[]> _annotationsCache = new FastIntMap();

    @JTranscSync
    public static <T> int[] getInterfaceIds(int classId) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.checkClassId(classId) ? ProgramReflection._classInfos[classId].interfaces : new int[]{};
    }

    @JTranscSync
    private static boolean checkClassId(int classId) {
        ProgramReflection._ensure();
        return classId >= 0 && classId < ProgramReflection._classInfos.length;
    }

    @JTranscSync
    public static <T> int getSuperclassId(int classId) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.checkClassId(classId) ? ProgramReflection._classInfos[classId].parent : -1;
    }

    @JTranscSync
    public static Class<?> getSuperclassById(int classId) {
        return JTranscCoreReflection.getClassById(JTranscCoreReflection.getSuperclassId(classId));
    }

    @JTranscSync
    public static <T> Constructor<T>[] getDeclaredConstructors(Class<?> clazz) {
        int classId = JTranscCoreReflection.getClassId(clazz);
        Constructor[] cache = (Constructor[])_constructorsCache.get(classId);
        if (cache != null) {
            return cache;
        }
        MemberInfo[] membersInfo = ProgramReflection.getConstructors((int)classId);
        int count = membersInfo != null ? membersInfo.length : 0;
        cache = new Constructor[count];
        for (int n = 0; n < count; ++n) {
            cache[n] = new Constructor(clazz, membersInfo[n]);
        }
        _constructorsCache.set(classId, (Object)cache);
        return cache;
    }

    @JTranscSync
    public static Method[] getDeclaredMethods(Class<?> clazz) {
        int classId = JTranscCoreReflection.getClassId(clazz);
        Method[] cache = (Method[])_methodsCache.get(classId);
        if (cache != null) {
            return cache;
        }
        MemberInfo[] membersInfo = ProgramReflection.getMethods((int)classId);
        int count = membersInfo != null ? membersInfo.length : 0;
        cache = new Method[count];
        for (int n = 0; n < count; ++n) {
            cache[n] = new Method(clazz, membersInfo[n]);
        }
        _methodsCache.set(classId, (Object)cache);
        return cache;
    }

    @JTranscSync
    public static Field[] getDeclaredFields(Class<?> clazz) {
        int classId = JTranscCoreReflection.getClassId(clazz);
        Field[] cache = (Field[])_fieldsCache.get(classId);
        if (cache != null) {
            return cache;
        }
        MemberInfo[] membersInfo = ProgramReflection.getFields((int)classId);
        int count = membersInfo != null ? membersInfo.length : 0;
        cache = new Field[count];
        for (int n = 0; n < count; ++n) {
            cache[n] = new Field(clazz, membersInfo[n]);
        }
        _fieldsCache.set(classId, (Object)cache);
        return cache;
    }

    @JTranscSync
    public static int getClassId(Class<?> clazz) {
        return clazz.id;
    }

    @JTranscSync
    private static int getClassIdByName(String name) {
        ProgramReflection._ensure();
        return ((ClassInfo)ProgramReflection._classInfosByName.get((String)name)).id;
    }

    @JTranscSync
    public static String getClassNameById(int id) {
        if (!JTranscCoreReflection.checkClassId(id)) {
            return null;
        }
        ProgramReflection._ensure();
        return ProgramReflection._classInfos[id].name;
    }

    @JTranscSync
    public static String[] getClassNames() {
        ProgramReflection._ensure();
        return ProgramReflection._classNames;
    }

    @JTranscSync
    public static Class<?> getClassById(int id) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.getClassByName(JTranscCoreReflection.getClassNameById(id));
    }

    @JTranscSync
    public static Class<?> getClassByName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @JTranscSync
    public static String getClassName(Class<?> clazz) {
        return clazz.getName();
    }

    @JTranscSync
    public static boolean hasClassWithName(String name) {
        return ProgramReflection.hasClassWithName((String)name);
    }

    @JTranscSync
    public static int getClassIdWithName(String name) {
        ProgramReflection._ensure();
        return JTranscCoreReflection.hasClassWithName(name) ? ((ClassInfo)ProgramReflection._classInfosByName.get((String)name)).id : -1;
    }

    @JTranscSync
    public static ClassInfo getClassInfoWithName(String name) {
        return ProgramReflection.getClassInfoWithName((String)name);
    }

    @JTranscSync
    public static Annotation[] getDeclaredAnnotations(Class<?> clazz) {
        ProgramReflection._ensure();
        int classId = JTranscCoreReflection.getClassId(clazz);
        Annotation[] cache = (Annotation[])_annotationsCache.get(classId);
        if (cache != null) {
            return cache;
        }
        cache = ProgramReflection.getClassAnnotations((int)JTranscCoreReflection.getClassId(clazz));
        _annotationsCache.set(classId, (Object)cache);
        return cache;
    }

    @JTranscInline
    @JTranscSync
    public static int getModifiersWithId(int classId) {
        ProgramReflection._ensure();
        return ProgramReflection._classInfos[classId].modifiers;
    }

    @HaxeMethodBody(value="return (p0 != null) ? Std.is(p0, JA_0) : false;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0 ? (p0 instanceof JA_0) : false;"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT(JA_0, p0) != nullptr;"}), @JTranscMethodBody(target="d", value={"return (cast(JA_0)p0) !is null;"}), @JTranscMethodBody(target="cs", value={"return p0 is JA_0;"}), @JTranscMethodBody(target="as3", value={"return p0 is JA_0;"}), @JTranscMethodBody(target="dart", value={"return p0 is JA_0;"}), @JTranscMethodBody(target="php", value={"return $p0 instanceof JA_0;"})})
    @JTranscSync
    public static native boolean isArray(Object var0);

    @HaxeMethodBody(value="return (p0 != null) ? N.str(cast(p0, JA_0).desc) : null;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0 ? N.str(p0.desc) : null;"}), @JTranscMethodBody(target="cpp", value={"return N::str(GET_OBJECT(JA_0, p0)->desc);"}), @JTranscMethodBody(target="d", value={"return N.str((cast(JA_0)p0).desc);"}), @JTranscMethodBody(target="cs", value={"return N.str(((JA_0)p0).desc);"}), @JTranscMethodBody(target="as3", value={"return N.str((p0 as JA_0).desc);"}), @JTranscMethodBody(target="dart", value={"return N.str((p0 as JA_0).desc);"}), @JTranscMethodBody(target="php", value={"return N::str($p0->desc);"})})
    @JTranscSync
    public static native String getArrayDescriptor(Object var0);

    @HaxeMethodBody(value="return p0.__JT__CLASS_ID;")
    @JTranscMethodBodyList(value={@JTranscMethodBody(target="js", value={"return p0.__JT__CLASS_ID;"}), @JTranscMethodBody(target="cpp", value={"return GET_OBJECT_NPE({% CLASS java.lang.Object %}, p0)->__JT__CLASS_ID;"}), @JTranscMethodBody(target="d", value={"return p0.__JT__CLASS_ID;"}), @JTranscMethodBody(target="cs", value={"return p0.__JT__CLASS_ID;"}), @JTranscMethodBody(target="as3", value={"return p0.__JT__CLASS_ID;"}), @JTranscMethodBody(target="dart", value={"return p0.__JT__CLASS_ID;"}), @JTranscMethodBody(target="php", value={"return $p0->__JT__CLASS_ID;"})})
    @JTranscSync
    public static int getClassId(Object obj) {
        return -1;
    }
}

