/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.ds.FastIntMap;
import com.jtransc.io.JTranscConsole;
import j.MemberInfo;
import j.ProgramReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect._InternalUtils;

public final class Field
extends AccessibleObject
implements Member {
    protected int typeId;
    public Class<?> clazz;
    public String name;
    protected int modifiers;
    public int slot;
    public transient String signature;
    public transient String genericSignature;
    public byte[] annotations;
    private static final FastIntMap<FastIntMap<Annotation[]>> _annotationsCache = new FastIntMap();
    private Type genericType;

    @Override
    @JTranscSync
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] cache;
        FastIntMap map = (FastIntMap)_annotationsCache.get(this.clazz.id);
        if (map != null && (cache = (Annotation[])map.get(this.info.id)) != null) {
            return cache;
        }
        if (map == null) {
            map = new FastIntMap();
            _annotationsCache.set(this.clazz.id, (Object)map);
        }
        if ((cache = ProgramReflection.getFieldAnnotations((int)this.clazz.id, (int)this.info.id)) == null) {
            cache = new Annotation[]{};
        }
        map.set(this.info.id, (Object)cache);
        return cache;
    }

    @JTranscSync
    public Field(Class<?> containingClass, MemberInfo info) {
        super(info);
        this.clazz = containingClass;
        this.slot = info.id;
        this.name = info.name;
        this.signature = info.desc;
        this.genericSignature = info.genericDesc;
        this.modifiers = info.modifiers;
    }

    @JTranscSync
    public Field() {
    }

    @Override
    @JTranscSync
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    @JTranscSync
    public String getName() {
        return this.name;
    }

    @Override
    @JTranscSync
    public int getModifiers() {
        return this.modifiers;
    }

    @JTranscSync
    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    @JTranscSync
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    @JTranscSync
    boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @JTranscSync
    public Class<?> getType() {
        try {
            return Class.forName(this.signature);
        }
        catch (ClassNotFoundException e) {
            JTranscConsole.syncPrintStackTrace((Throwable)e);
            return null;
        }
    }

    @JTranscSync
    public Type getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.genericSignature != null ? _InternalUtils.parseType(this.genericSignature, null) : this.getType();
        }
        return this.genericType;
    }

    @JTranscSync
    public boolean equals(Object obj) {
        return this == obj;
    }

    @JTranscSync
    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    @JTranscAsync
    public String toString() {
        int mod = this.getModifiers();
        return (mod == 0 ? "" : Modifier.toString(mod) + " ") + _InternalUtils.getTypeName(this.getType()) + " " + _InternalUtils.getTypeName(this.getDeclaringClass()) + "." + this.getName();
    }

    @JTranscSync
    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = this.getType();
        if (type == null) {
            return null;
        }
        return this._getObject(obj);
    }

    @JTranscSync
    private void _setObject(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        ProgramReflection.dynamicSet((int)this.clazz.id, (int)this.slot, (Object)obj, (Object)value);
    }

    @JTranscSync
    public Object _getObject(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return ProgramReflection.dynamicGet((int)this.clazz.id, (int)this.slot, (Object)obj);
    }

    @JTranscSync
    public boolean getBoolean(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Boolean)this.get(obj);
    }

    @JTranscSync
    public byte getByte(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Byte)this.get(obj);
    }

    @JTranscSync
    public char getChar(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return ((Character)this.get(obj)).charValue();
    }

    @JTranscSync
    public short getShort(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Short)this.get(obj);
    }

    @JTranscSync
    public int getInt(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Integer)this.get(obj);
    }

    @JTranscSync
    public long getLong(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Long)this.get(obj);
    }

    @JTranscSync
    public float getFloat(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return ((Float)this.get(obj)).floatValue();
    }

    @JTranscSync
    public double getDouble(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return (Double)this.get(obj);
    }

    @JTranscSync
    native String getInternalName();

    @JTranscSync
    public void set(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = this.getType();
        if (type != null) {
            this._setObject(obj, value);
        }
    }

    @JTranscSync
    public void setBoolean(Object obj, boolean v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    @JTranscSync
    public void setByte(Object obj, byte v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    @JTranscSync
    public void setChar(Object obj, char v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, Character.valueOf(v));
    }

    @JTranscSync
    public void setShort(Object obj, short v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    @JTranscSync
    public void setInt(Object obj, int v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    @JTranscSync
    public void setLong(Object obj, long v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    @JTranscSync
    public void setFloat(Object obj, float v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, Float.valueOf(v));
    }

    @JTranscSync
    public void setDouble(Object obj, double v) throws IllegalArgumentException, IllegalAccessException {
        this.set(obj, v);
    }

    @Override
    @JTranscSync
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return super.getAnnotation(annotationClass);
    }
}

