/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.jtransc.annotation.JTranscAsync;
import com.jtransc.annotation.JTranscInvisible;
import com.jtransc.annotation.JTranscKeep;
import com.jtransc.annotation.JTranscSync;
import com.jtransc.ds.FastIntMap;
import j.MemberInfo;
import j.ProgramReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.MethodTypeImpl;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect._InternalUtils;
import java.util.Arrays;

public abstract class MethodConstructor
extends AccessibleObject {
    protected int typeId;
    protected int id;
    protected Class<?> clazz;
    protected int slot;
    protected String name;
    protected Class<?>[] parameterTypes;
    protected Class<?>[] exceptionTypes = new Class[0];
    protected int modifiers;
    protected byte[] annotations;
    protected byte[] parameterAnnotations;
    protected byte[] annotationDefault;
    public transient String signature;
    private transient String jniSignature;
    protected transient String genericSignature;
    @JTranscInvisible
    private MethodTypeImpl methodType;
    @JTranscInvisible
    private MethodTypeImpl genericMethodType;
    private static final FastIntMap<FastIntMap<Annotation[]>> _annotationsCache = new FastIntMap();
    private static final FastIntMap<FastIntMap<Annotation[][]>> _annotationArgsCache = new FastIntMap();
    private Parameter[] _params;

    @JTranscSync
    public static String getSignature(Method method) {
        return method.signature;
    }

    @JTranscSync
    public static String getSignature(Constructor constructor) {
        return constructor.signature;
    }

    @JTranscSync
    public MethodConstructor(Class<?> containingClass, MemberInfo info) {
        super(info);
        this.clazz = containingClass;
        this.id = info.id;
        this.slot = info.id;
        this.name = info.name;
        this.signature = info.desc;
        this.genericSignature = info.genericDesc;
        this.modifiers = info.modifiers;
        this.jniSignature = MethodConstructor.getJniSignature(this.signature);
    }

    @JTranscInvisible
    @JTranscKeep
    @JTranscSync
    private static String getJniSignature(String sig) {
        String newSig = "";
        int firstIndex = sig.indexOf(40) + 1;
        int lastIndex = sig.indexOf(41);
        String s = sig.substring(firstIndex, lastIndex);
        int arrayDim = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != 'L' && s.charAt(i) != '[') {
                if (arrayDim == 0) {
                    newSig = newSig + s.charAt(i);
                }
                arrayDim = 0;
                continue;
            }
            if (s.charAt(i) == 'L') {
                while (i < s.length() && s.charAt(i) != ';') {
                    ++i;
                }
                if (arrayDim == 0) {
                    newSig = newSig + 'L';
                }
                arrayDim = 0;
                continue;
            }
            if (s.charAt(i) != '[') continue;
            if (arrayDim == 0) {
                newSig = newSig + '[';
            }
            ++arrayDim;
        }
        return newSig;
    }

    @Override
    @JTranscSync
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] cache;
        FastIntMap map = (FastIntMap)_annotationsCache.get(this.clazz.id);
        if (map == null) {
            map = new FastIntMap();
            _annotationsCache.set(this.clazz.id, (Object)map);
        } else {
            cache = (Annotation[])map.get(this.info.id);
            if (cache != null) {
                return cache;
            }
        }
        cache = ProgramReflection.getMethodAnnotations((int)this.clazz.id, (int)this.info.id);
        if (cache == null) {
            cache = new Annotation[]{};
        }
        map.set(this.info.id, (Object)cache);
        return cache;
    }

    @JTranscInvisible
    @JTranscSync
    protected MethodTypeImpl methodType() {
        if (this.methodType == null) {
            this.methodType = _InternalUtils.parseMethodType(this.signature, null);
        }
        return this.methodType;
    }

    @JTranscSync
    public int getParameterCount() {
        return this.methodType().args.length;
    }

    @JTranscSync
    public Class<?>[] getExceptionTypes() {
        return Arrays.copyOf(this.exceptionTypes, this.exceptionTypes.length);
    }

    @JTranscInvisible
    @JTranscSync
    protected MethodTypeImpl genericMethodType() {
        if (this.genericMethodType == null) {
            this.genericMethodType = this.genericSignature != null ? _InternalUtils.parseMethodType(this.genericSignature, null) : this.methodType();
        }
        return this.genericMethodType;
    }

    @JTranscSync
    public Annotation[][] getParameterAnnotations() {
        Annotation[][] cache;
        FastIntMap map = (FastIntMap)_annotationArgsCache.get(this.clazz.id);
        if (map == null) {
            map = new FastIntMap();
            _annotationArgsCache.set(this.clazz.id, (Object)map);
        } else {
            cache = (Annotation[][])map.get(this.info.id);
            if (cache != null) {
                return cache;
            }
        }
        int count = this.getParameterTypes().length;
        cache = new Annotation[count][];
        for (int n = 0; n < count; ++n) {
            Annotation[] annotations = ProgramReflection.getMethodArgumentAnnotations((int)this.clazz.id, (int)this.info.id, (int)n);
            cache[n] = annotations != null ? annotations : new Annotation[]{};
        }
        map.set(this.info.id, (Object)cache);
        return cache;
    }

    @JTranscSync
    public Class<?> getReturnType() {
        return null;
    }

    @JTranscSync
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @JTranscSync
    public int getModifiers() {
        return this.modifiers;
    }

    @JTranscSync
    public String getName() {
        return null;
    }

    @JTranscSync
    protected abstract boolean isConstructor();

    @JTranscSync
    public Class<?>[] getParameterTypes() {
        return (Class[])this.methodType().args;
    }

    @JTranscSync
    public Parameter[] getParameters() {
        if (this._params == null) {
            Class<?>[] parameterTypes = this.getParameterTypes();
            this._params = new Parameter[parameterTypes.length];
            for (int n = 0; n < parameterTypes.length; ++n) {
                this._params[n] = new Parameter(this, n);
            }
        }
        return Arrays.copyOf(this._params, this._params.length);
    }

    @JTranscSync
    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @JTranscSync
    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @JTranscSync
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    @JTranscSync
    public boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    @JTranscAsync
    public String toString() {
        int mod = this.getModifiers();
        String out = "";
        if (mod != 0) {
            out = out + Modifier.toString(mod) + " ";
        }
        if (this.getReturnType() != null) {
            out = out + _InternalUtils.getTypeName(this.getReturnType()) + " ";
        }
        out = out + _InternalUtils.getTypeName(this.getDeclaringClass());
        if (!this.isConstructor()) {
            out = out + "." + this.getName();
        }
        out = out + "(";
        boolean first = true;
        for (Class<?> param : this.getParameterTypes()) {
            if (!first) {
                out = out + ",";
            }
            out = out + _InternalUtils.getTypeName(param);
            first = false;
        }
        out = out + ")";
        return out;
    }
}

