/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AllPermission;
import java.security.Permission;

public abstract class HttpURLConnection
extends URLConnection {
    protected String method = "GET";
    private static final String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"};
    protected int chunkLength = -1;
    protected int fixedContentLength = -1;
    protected long fixedContentLengthLong = -1L;
    protected int responseCode = -1;
    protected String responseMessage = null;
    protected boolean instanceFollowRedirects = true;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    @Deprecated
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;

    @Override
    public native String getHeaderFieldKey(int var1);

    public native void setFixedLengthStreamingMode(int var1);

    public native void setFixedLengthStreamingMode(long var1);

    public native void setChunkedStreamingMode(int var1);

    @Override
    public native String getHeaderField(int var1);

    protected HttpURLConnection(URL u) {
        super(u);
    }

    public static native void setFollowRedirects(boolean var0);

    public static native boolean getFollowRedirects();

    public native void setInstanceFollowRedirects(boolean var1);

    public native boolean getInstanceFollowRedirects();

    public void setRequestMethod(String method) throws Exception {
        if (this.connected) {
            throw new Exception("Can't reset method: already connected");
        }
        for (String methodVar : methods) {
            if (!methodVar.equals(method.toUpperCase())) continue;
            this.method = methodVar;
            return;
        }
        throw new Exception("Invalid HTTP method: " + method);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode == -1) {
            this.getInputStream();
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        this.getResponseCode();
        return this.responseMessage;
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        return 0L;
    }

    public abstract void disconnect();

    public abstract boolean usingProxy();

    @Override
    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public InputStream getErrorStream() {
        return null;
    }
}

