/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.jtransc.JTranscArrays;
import com.jtransc.annotation.JTranscSync;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBufferAsCharBuffer;
import java.nio.ByteBufferAsDoubleBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsLongBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import libcore.io.Memory;

public class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer> {
    ByteOrder order;
    boolean isNativeOrder;
    boolean isLittleEndian;
    public final byte[] backingArray;
    final int arrayOffset;
    private final boolean isReadOnly;
    private boolean isDirect;

    ByteBuffer(byte[] backingArray) {
        this(backingArray.length, backingArray, 0, false);
        this.isDirect = false;
    }

    ByteBuffer(byte[] backingArray, boolean isDirect) {
        this(backingArray.length, backingArray, 0, false);
        this.isDirect = isDirect;
    }

    ByteBuffer(int capacity, byte[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(0, capacity, null);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
        this.order(ByteOrder.BIG_ENDIAN);
        if (arrayOffset + capacity > backingArray.length) {
            throw new IndexOutOfBoundsException("backingArray.length=" + backingArray.length + ", capacity=" + capacity + ", arrayOffset=" + arrayOffset);
        }
    }

    public static ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new ByteBuffer(new byte[capacity]);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new ByteBuffer(new byte[capacity], true);
    }

    public static ByteBuffer wrap(byte[] array) {
        return new ByteBuffer(array);
    }

    public static ByteBuffer wrap(byte[] array, int start, int byteCount) {
        JTranscArrays.checkOffsetAndCount((int)array.length, (int)start, (int)byteCount);
        ByteBuffer buf = new ByteBuffer(array);
        buf.position = start;
        buf.limit = start + byteCount;
        return buf;
    }

    @JTranscSync
    public final byte[] array() {
        this._checkWritable();
        return this.backingArray;
    }

    @Override
    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public final CharBuffer asCharBuffer() {
        return ByteBufferAsCharBuffer.asCharBuffer(this);
    }

    public final DoubleBuffer asDoubleBuffer() {
        return ByteBufferAsDoubleBuffer.asDoubleBuffer(this);
    }

    public final FloatBuffer asFloatBuffer() {
        return ByteBufferAsFloatBuffer.asFloatBuffer(this);
    }

    public final IntBuffer asIntBuffer() {
        return ByteBufferAsIntBuffer.asIntBuffer(this);
    }

    public final LongBuffer asLongBuffer() {
        return ByteBufferAsLongBuffer.asLongBuffer(this);
    }

    public final ShortBuffer asShortBuffer() {
        return ByteBufferAsShortBuffer.asShortBuffer(this);
    }

    @Override
    public int compareTo(ByteBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            byte otherByte;
            byte thisByte = this.get(thisPos);
            if (thisByte != (otherByte = otherBuffer.get(otherPos))) {
                return thisByte < otherByte ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public ByteBuffer duplicate() {
        return ByteBuffer.copy(this, this.mark, this.isReadOnly);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer otherBuffer = (ByteBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    @Override
    public final boolean isDirect() {
        return this.isDirect;
    }

    public final ByteOrder order() {
        return this.order;
    }

    public final ByteBuffer order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        this.order = byteOrder;
        this.isNativeOrder = byteOrder == ByteOrder.nativeOrder();
        this.isLittleEndian = byteOrder == ByteOrder.LITTLE_ENDIAN;
        return this;
    }

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public ByteBuffer put(ByteBuffer src) {
        this._checkWritable();
        if (src == this) {
            throw new IllegalArgumentException("src == this");
        }
        int srcByteCount = src.remaining();
        if (srcByteCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public ByteBuffer putChar(int index, char value) {
        this._checkWritable();
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.arrayOffset + index, (short)value, this.isLittleEndian);
        return this;
    }

    public ByteBuffer putDouble(int index, double value) {
        return this.putLong(index, Double.doubleToRawLongBits(value));
    }

    public ByteBuffer putFloat(int index, float value) {
        return this.putInt(index, Float.floatToRawIntBits(value));
    }

    public ByteBuffer putInt(int index, int value) {
        this._checkWritable();
        this.checkIndex(index, 4);
        Memory.pokeInt(this.backingArray, this.arrayOffset + index, value, this.isLittleEndian);
        return this;
    }

    public ByteBuffer putLong(int index, long value) {
        this._checkWritable();
        this.checkIndex(index, 8);
        Memory.pokeLong(this.backingArray, this.arrayOffset + index, value, this.isLittleEndian);
        return this;
    }

    public ByteBuffer putShort(int index, short value) {
        this._checkWritable();
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.arrayOffset + index, value, this.isLittleEndian);
        return this;
    }

    public ByteBuffer slice() {
        return new ByteBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    private static ByteBuffer copy(ByteBuffer other, int markOfOther, boolean isReadOnly) {
        ByteBuffer buf = new ByteBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    public ByteBuffer asReadOnlyBuffer() {
        return ByteBuffer.copy(this, this.mark, true);
    }

    public ByteBuffer compact() {
        this._checkWritable();
        System.arraycopy(this.backingArray, this.position + this.arrayOffset, this.backingArray, this.arrayOffset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    @JTranscSync
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @JTranscSync
    private void _checkWritable() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
    }

    @JTranscSync
    byte[] protectedArray() {
        this._checkWritable();
        return this.backingArray;
    }

    @JTranscSync
    int protectedArrayOffset() {
        this._checkWritable();
        return this.arrayOffset;
    }

    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    public final ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        this.checkGetBounds(1, dst.length, dstOffset, byteCount);
        System.arraycopy(this.backingArray, this.arrayOffset + this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    final void get(char[] dst, int dstOffset, int charCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, charCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(double[] dst, int dstOffset, int doubleCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, doubleCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(float[] dst, int dstOffset, int floatCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, floatCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(int[] dst, int dstOffset, int intCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, intCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(long[] dst, int dstOffset, int longCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, longCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    final void get(short[] dst, int dstOffset, int shortCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, shortCount);
        this.position += byteCount;
        throw new RuntimeException("Not implemented");
    }

    public ByteBuffer put(int index, byte b) {
        this._checkWritable();
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = b;
        return this;
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        this._checkWritable();
        this.checkPutBounds(1, src.length, srcOffset, byteCount);
        System.arraycopy(src, srcOffset, this.backingArray, this.arrayOffset + this.position, byteCount);
        this.position += byteCount;
        return this;
    }

    public final byte get() {
        return this.get(this.position++);
    }

    public final char getChar() {
        char out = this.getChar(this.position);
        this.position += 2;
        return out;
    }

    public final short getShort() {
        short out = this.getShort(this.position);
        this.position += 2;
        return out;
    }

    public final int getInt() {
        int out = this.getInt(this.position);
        this.position += 4;
        return out;
    }

    public final long getLong() {
        long out = this.getLong(this.position);
        this.position += 8;
        return out;
    }

    public final float getFloat() {
        float out = this.getFloat(this.position);
        this.position += 4;
        return out;
    }

    public final double getDouble() {
        double out = this.getDouble(this.position);
        this.position += 8;
        return out;
    }

    public final byte get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    public final char getChar(int index) {
        this.checkIndex(index, 2);
        return (char)Memory.peekShort(this.backingArray, this.arrayOffset + index, this.isLittleEndian);
    }

    public final short getShort(int index) {
        this.checkIndex(index, 2);
        return Memory.peekShort(this.backingArray, this.arrayOffset + index, this.isLittleEndian);
    }

    public final int getInt(int index) {
        this.checkIndex(index, 4);
        return Memory.peekInt(this.backingArray, this.arrayOffset + index, this.isLittleEndian);
    }

    public final long getLong(int index) {
        this.checkIndex(index, 8);
        return Memory.peekLong(this.backingArray, this.arrayOffset + index, this.isLittleEndian);
    }

    public final float getFloat(int index) {
        this.checkIndex(index, 4);
        return Memory.peekFloat(this.backingArray, this.arrayOffset + index, this.isLittleEndian);
    }

    public final double getDouble(int index) {
        this.checkIndex(index, 8);
        return Memory.peekDouble(this.backingArray, this.arrayOffset + index, this.isLittleEndian);
    }

    public ByteBuffer put(byte b) {
        return this.put(this.position++, b);
    }

    public ByteBuffer putChar(char value) {
        this.putChar(this.position, value);
        this.position += 2;
        return this;
    }

    public ByteBuffer putShort(short value) {
        this.putShort(this.position, value);
        this.position += 2;
        return this;
    }

    public ByteBuffer putInt(int value) {
        this.putInt(this.position, value);
        this.position += 4;
        return this;
    }

    public ByteBuffer putLong(long value) {
        this.putLong(this.position, value);
        this.position += 8;
        return this;
    }

    public ByteBuffer putFloat(float value) {
        return this.putInt(Float.floatToRawIntBits(value));
    }

    public ByteBuffer putDouble(double value) {
        return this.putLong(Double.doubleToRawLongBits(value));
    }
}

