/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import com.jtransc.annotation.JTranscSync;
import com.jtransc.charset.JTranscCharset;
import com.jtransc.ds.FastStringMap;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;

public abstract class Charset
implements Comparable<Charset> {
    private static FastStringMap<Charset> charsets = null;
    private static Charset _default;
    private String canonicalName;
    private Set<String> aliases;
    private CharsetEncoder ce;

    public static boolean isSupported(String charsetName) {
        try {
            Charset.forName(charsetName);
            return true;
        }
        catch (UnsupportedCharsetException e) {
            return false;
        }
    }

    public static native SortedMap<String, Charset> availableCharsets();

    private static Charset toCharset(final JTranscCharset jCharset) {
        return new Charset(jCharset.getCannonicalName(), jCharset.getAliases()){

            @Override
            public boolean contains(Charset cs) {
                return false;
            }

            @Override
            public CharsetDecoder newDecoder() {
                return new CharsetDecoder(this, jCharset.avgBytesPerCharacter(), jCharset.maxBytesPerCharacter()){

                    @Override
                    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                        jCharset.decode(in, out);
                        return CoderResult.UNDERFLOW;
                    }
                };
            }

            @Override
            public CharsetEncoder newEncoder() {
                return new CharsetEncoder(this, jCharset.avgBytesPerCharacter(), jCharset.maxBytesPerCharacter()){

                    @Override
                    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
                        char[] chars = new char[in.remaining()];
                        in.get(chars);
                        out.put(jCharset.encode(new String(chars)));
                        return CoderResult.UNDERFLOW;
                    }
                };
            }
        };
    }

    public static Charset forName(String charsetName) {
        charsetName = charsetName.toUpperCase().trim();
        if (charsets == null) {
            charsets = new FastStringMap();
            Set jCharsets = JTranscCharset.getSupportedCharsetsSet();
            for (JTranscCharset jCharset : jCharsets) {
                Charset charset = Charset.toCharset(jCharset);
                for (String alias : jCharset.getAliases()) {
                    charsets.set(alias.toUpperCase().trim(), (Object)charset);
                }
            }
        }
        if (charsets.has(charsetName)) {
            return (Charset)charsets.get(charsetName);
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    public static Charset defaultCharset() {
        Class<CoderResult> dummy1 = CoderResult.class;
        if (_default == null) {
            _default = Charset.forName(JTranscCharset.defaultCharset().getCannonicalName());
        }
        return _default;
    }

    protected Charset(String canonicalName, String[] aliases) {
        this.canonicalName = canonicalName;
        this.aliases = new HashSet<String>();
        for (int n = 0; n < aliases.length; ++n) {
            this.aliases.add(aliases[n]);
        }
    }

    @JTranscSync
    public final String name() {
        return this.canonicalName;
    }

    @JTranscSync
    public String displayName() {
        return this.canonicalName;
    }

    @JTranscSync
    public final Set<String> aliases() {
        return this.aliases;
    }

    @JTranscSync
    public final boolean isRegistered() {
        return true;
    }

    @JTranscSync
    public String displayName(Locale locale) {
        return this.canonicalName;
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();

    @JTranscSync
    public boolean canEncode() {
        return true;
    }

    public final CharBuffer decode(ByteBuffer bb) {
        try {
            return this.newDecoder().decode(bb);
        }
        catch (CharacterCodingException e) {
            throw new Error(e);
        }
    }

    public final ByteBuffer encode(CharBuffer cb) {
        try {
            return this.newEncoder().encode(cb);
        }
        catch (CharacterCodingException e) {
            throw new Error(e);
        }
    }

    public final ByteBuffer encode(String str) {
        return this.encode(CharBuffer.wrap(str));
    }

    public final int hashCode() {
        return this.displayName().hashCode();
    }

    @Override
    public final native int compareTo(Charset var1);

    public final native boolean equals(Object var1);

    public final String toString() {
        return this.displayName();
    }
}

