/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.List;

public final class Duration
implements TemporalAmount,
Comparable<Duration>,
Serializable {
    public static final Duration ZERO = new Duration(0L, 0);
    private final long seconds;
    private final int nanos;

    private Duration(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public static Duration ofDays(long days) {
        return new Duration(days * 86400L, 0);
    }

    public static Duration ofHours(long hours) {
        return new Duration(hours * 3600L, 0);
    }

    public static Duration ofMinutes(long minutes) {
        return new Duration(minutes * 60L, 0);
    }

    public static Duration ofSeconds(long seconds) {
        return new Duration(seconds, 0);
    }

    public static Duration ofSeconds(long seconds, long nanoAdjustment) {
        return new Duration(seconds + nanoAdjustment / 1000000000L, (int)(nanoAdjustment % 1000000000L));
    }

    public static native Duration ofMillis(long var0);

    public static Duration ofNanos(long nanos) {
        return Duration.ofSeconds(0L, nanos);
    }

    public static native Duration of(long var0, TemporalUnit var2);

    public static native Duration from(TemporalAmount var0);

    public static native Duration parse(CharSequence var0);

    public static native Duration between(Temporal var0, Temporal var1);

    @Override
    public native long get(TemporalUnit var1);

    @Override
    public native List<TemporalUnit> getUnits();

    public boolean isZero() {
        return this.seconds == 0L && this.nanos == 0;
    }

    public boolean isNegative() {
        return this.seconds < 0L;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNano() {
        return this.nanos;
    }

    public Duration withSeconds(long seconds) {
        return new Duration(seconds, this.nanos);
    }

    public Duration withNanos(int nanoOfSecond) {
        return new Duration(this.seconds, this.nanos);
    }

    private Duration _plus(long seconds, long nanos) {
        return Duration.ofSeconds(this.seconds + seconds, (long)this.nanos + nanos);
    }

    private Duration _minus(long seconds, long nanos) {
        return Duration.ofSeconds(this.seconds - seconds, (long)this.nanos - nanos);
    }

    public Duration plus(Duration delta) {
        return this._plus(delta.seconds, delta.nanos);
    }

    public native Duration plus(long var1, TemporalUnit var3);

    public Duration plusDays(long delta) {
        return this._plus(delta * 86400L, 0L);
    }

    public Duration plusHours(long delta) {
        return this._plus(delta * 3600L, 0L);
    }

    public Duration plusMinutes(long delta) {
        return this._plus(delta * 60L, 0L);
    }

    public Duration plusSeconds(long delta) {
        return this._plus(delta, 0L);
    }

    public Duration plusMillis(long delta) {
        return this._plus(0L, delta * 1000000L);
    }

    public Duration plusNanos(long delta) {
        return this._plus(0L, delta);
    }

    public Duration minus(Duration delta) {
        return this._minus(delta.seconds, delta.nanos);
    }

    public native Duration minus(long var1, TemporalUnit var3);

    public Duration minusDays(long delta) {
        return this._minus(delta * 86400L, 0L);
    }

    public Duration minusHours(long delta) {
        return this._minus(delta * 3600L, 0L);
    }

    public Duration minusMinutes(long delta) {
        return this._minus(delta * 60L, 0L);
    }

    public Duration minusSeconds(long delta) {
        return this._minus(delta, 0L);
    }

    public Duration minusMillis(long delta) {
        return this._minus(0L, delta * 1000000L);
    }

    public Duration minusNanos(long delta) {
        return this._minus(0L, delta);
    }

    public Duration multipliedBy(long multiplicand) {
        return Duration.ofSeconds(this.seconds * multiplicand, (long)this.nanos * multiplicand);
    }

    public Duration dividedBy(long divisor) {
        return Duration.ofSeconds(this.seconds * divisor, (long)this.nanos * divisor);
    }

    public native Duration negated();

    public native Duration abs();

    @Override
    public native Temporal addTo(Temporal var1);

    @Override
    public native Temporal subtractFrom(Temporal var1);

    public long toDays() {
        return this.seconds / 86400L;
    }

    public long toHours() {
        return this.seconds / 3600L;
    }

    public long toMinutes() {
        return this.seconds / 60L;
    }

    public long toMillis() {
        return this.seconds * 1000L + (long)(this.nanos / 1000000);
    }

    public long toNanos() {
        return this.seconds * 1000000000L + (long)this.nanos;
    }

    @Override
    public native int compareTo(Duration var1);

    public native boolean equals(Object var1);

    public int hashCode() {
        return (int)(this.seconds + (long)this.nanos);
    }

    public native String toString();
}

