/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;

public final class Instant
implements Temporal,
TemporalAdjuster,
Comparable<Instant>,
Serializable {
    public static final Instant EPOCH = new Instant(0L, 0);
    public static final Instant MIN = Instant.ofEpochSecond(-31557014167219200L, 0L);
    public static final Instant MAX = Instant.ofEpochSecond(31556889864403199L, 999999999L);
    private final long seconds;
    private final int nanos;

    private Instant(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public static Instant now() {
        return Clock.systemUTC().instant();
    }

    public static Instant now(Clock clock) {
        return clock.instant();
    }

    public static Instant ofEpochSecond(long epochSecond) {
        return new Instant(epochSecond, 0);
    }

    public static Instant ofEpochSecond(long epochSecond, long nanoAdjustment) {
        return new Instant(epochSecond + nanoAdjustment / 1000000000L, (int)(nanoAdjustment % 1000000000L));
    }

    public static Instant ofEpochMilli(long epochMilli) {
        return Instant.ofEpochSecond(epochMilli / 1000L, epochMilli * 1000000L);
    }

    public static native Instant from(TemporalAccessor var0);

    public static native Instant parse(CharSequence var0);

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native boolean isSupported(TemporalUnit var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public native long getLong(TemporalField var1);

    public long getEpochSecond() {
        return this.seconds;
    }

    public int getNano() {
        return this.nanos;
    }

    @Override
    public native Instant with(TemporalAdjuster var1);

    @Override
    public native Instant with(TemporalField var1, long var2);

    public native Instant truncatedTo(TemporalUnit var1);

    @Override
    public native Instant plus(TemporalAmount var1);

    private Instant _plus(long secondsToAdd, long nanosToAdd) {
        return Instant.ofEpochSecond(this.seconds + secondsToAdd, (long)this.nanos + nanosToAdd);
    }

    private Instant _minus(long secondsToAdd, long nanosToAdd) {
        return Instant.ofEpochSecond(this.seconds - secondsToAdd, (long)this.nanos - nanosToAdd);
    }

    @Override
    public native Instant plus(long var1, TemporalUnit var3);

    public Instant plusSeconds(long delta) {
        return this._plus(delta, 0L);
    }

    public Instant plusMillis(long delta) {
        return this._plus(0L, delta * 1000000L);
    }

    public Instant plusNanos(long delta) {
        return this._plus(0L, delta);
    }

    @Override
    public native Instant minus(TemporalAmount var1);

    @Override
    public native Instant minus(long var1, TemporalUnit var3);

    public Instant minusSeconds(long delta) {
        return this._minus(delta, 0L);
    }

    public Instant minusMillis(long delta) {
        return this._minus(0L, delta * 1000000L);
    }

    public Instant minusNanos(long delta) {
        return this._minus(0L, delta);
    }

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native Temporal adjustInto(Temporal var1);

    @Override
    public native long until(Temporal var1, TemporalUnit var2);

    public native OffsetDateTime atOffset(ZoneOffset var1);

    public native ZonedDateTime atZone(ZoneId var1);

    public long toEpochMilli() {
        return this.seconds * 1000L + (long)(this.nanos / 1000000);
    }

    @Override
    public native int compareTo(Instant var1);

    public native boolean isAfter(Instant var1);

    public native boolean isBefore(Instant var1);

    public native boolean equals(Object var1);

    public native int hashCode();

    public native String toString();
}

