/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Era;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;

public final class LocalDate
implements Temporal,
TemporalAdjuster,
ChronoLocalDate,
Serializable {
    public static final LocalDate MIN = LocalDate.of(-999999999, 1, 1);
    public static final LocalDate MAX = LocalDate.of(999999999, 12, 31);
    private final int year;
    private final short month;
    private final short day;

    public LocalDate(int year, short month, short day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public static native LocalDate now();

    public static native LocalDate now(ZoneId var0);

    public static native LocalDate now(Clock var0);

    public static LocalDate of(int year, Month month, int dayOfMonth) {
        return new LocalDate(year, (short)month.getValue(), (short)dayOfMonth);
    }

    public static LocalDate of(int year, int month, int dayOfMonth) {
        return new LocalDate(year, (short)month, (short)dayOfMonth);
    }

    public static native LocalDate ofYearDay(int var0, int var1);

    public static native LocalDate ofEpochDay(long var0);

    public static native LocalDate from(TemporalAccessor var0);

    public static native LocalDate parse(CharSequence var0);

    public static native LocalDate parse(CharSequence var0, DateTimeFormatter var1);

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native boolean isSupported(TemporalUnit var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public native int get(TemporalField var1);

    @Override
    public native long getLong(TemporalField var1);

    @Override
    public native IsoChronology getChronology();

    @Override
    public native Era getEra();

    public native int getYear();

    public native int getMonthValue();

    public native Month getMonth();

    public native int getDayOfMonth();

    public native int getDayOfYear();

    public native DayOfWeek getDayOfWeek();

    @Override
    public native boolean isLeapYear();

    @Override
    public native int lengthOfMonth();

    @Override
    public native int lengthOfYear();

    @Override
    public native LocalDate with(TemporalAdjuster var1);

    @Override
    public native LocalDate with(TemporalField var1, long var2);

    public native LocalDate withYear(int var1);

    public native LocalDate withMonth(int var1);

    public native LocalDate withDayOfMonth(int var1);

    public native LocalDate withDayOfYear(int var1);

    @Override
    public native LocalDate plus(TemporalAmount var1);

    @Override
    public native LocalDate plus(long var1, TemporalUnit var3);

    public native LocalDate plusYears(long var1);

    public native LocalDate plusMonths(long var1);

    public native LocalDate plusWeeks(long var1);

    public native LocalDate plusDays(long var1);

    @Override
    public native LocalDate minus(TemporalAmount var1);

    @Override
    public native LocalDate minus(long var1, TemporalUnit var3);

    public native LocalDate minusYears(long var1);

    public native LocalDate minusMonths(long var1);

    public native LocalDate minusWeeks(long var1);

    public native LocalDate minusDays(long var1);

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native Temporal adjustInto(Temporal var1);

    @Override
    public native long until(Temporal var1, TemporalUnit var2);

    @Override
    public native Period until(ChronoLocalDate var1);

    @Override
    public native String format(DateTimeFormatter var1);

    public native LocalDateTime atTime(LocalTime var1);

    public native LocalDateTime atTime(int var1, int var2);

    public native LocalDateTime atTime(int var1, int var2, int var3);

    public native LocalDateTime atTime(int var1, int var2, int var3, int var4);

    public native OffsetDateTime atTime(OffsetTime var1);

    public native LocalDateTime atStartOfDay();

    public native ZonedDateTime atStartOfDay(ZoneId var1);

    @Override
    public native long toEpochDay();

    @Override
    public native int compareTo(ChronoLocalDate var1);

    native int compareTo0(LocalDate var1);

    @Override
    public native boolean isAfter(ChronoLocalDate var1);

    @Override
    public native boolean isBefore(ChronoLocalDate var1);

    @Override
    public native boolean isEqual(ChronoLocalDate var1);

    @Override
    public native boolean equals(Object var1);

    @Override
    public native int hashCode();

    @Override
    public native String toString();
}

