/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;

public final class LocalTime
implements Temporal,
TemporalAdjuster,
Comparable<LocalTime>,
Serializable {
    public static final LocalTime MIN = new LocalTime(0, 0, 0, 0);
    public static final LocalTime MAX = new LocalTime(23, 59, 59, 999999999);
    public static final LocalTime MIDNIGHT = new LocalTime(0, 0, 0, 0);
    public static final LocalTime NOON = new LocalTime(12, 0, 0, 0);
    private final byte hour;
    private final byte minute;
    private final byte second;
    private final int nano;

    private LocalTime(int hour, int minute, int second, int nanoOfSecond) {
        this.hour = (byte)hour;
        this.minute = (byte)minute;
        this.second = (byte)second;
        this.nano = nanoOfSecond;
    }

    public static native LocalTime now();

    public static native LocalTime now(ZoneId var0);

    public static native LocalTime now(Clock var0);

    public static native LocalTime of(int var0, int var1);

    public static native LocalTime of(int var0, int var1, int var2);

    public static native LocalTime of(int var0, int var1, int var2, int var3);

    public static native LocalTime ofSecondOfDay(long var0);

    public static native LocalTime ofNanoOfDay(long var0);

    public static native LocalTime from(TemporalAccessor var0);

    public static native LocalTime parse(CharSequence var0);

    public static native LocalTime parse(CharSequence var0, DateTimeFormatter var1);

    @Override
    public native boolean isSupported(TemporalField var1);

    @Override
    public native boolean isSupported(TemporalUnit var1);

    @Override
    public native ValueRange range(TemporalField var1);

    @Override
    public native int get(TemporalField var1);

    @Override
    public native long getLong(TemporalField var1);

    public native int getHour();

    public native int getMinute();

    public native int getSecond();

    public native int getNano();

    @Override
    public native LocalTime with(TemporalAdjuster var1);

    @Override
    public native LocalTime with(TemporalField var1, long var2);

    public native LocalTime withHour(int var1);

    public native LocalTime withMinute(int var1);

    public native LocalTime withSecond(int var1);

    public native LocalTime withNano(int var1);

    public native LocalTime truncatedTo(TemporalUnit var1);

    @Override
    public native LocalTime plus(TemporalAmount var1);

    @Override
    public native LocalTime plus(long var1, TemporalUnit var3);

    public native LocalTime plusHours(long var1);

    public native LocalTime plusMinutes(long var1);

    public native LocalTime plusSeconds(long var1);

    public native LocalTime plusNanos(long var1);

    @Override
    public native LocalTime minus(TemporalAmount var1);

    @Override
    public native LocalTime minus(long var1, TemporalUnit var3);

    public native LocalTime minusHours(long var1);

    public native LocalTime minusMinutes(long var1);

    public native LocalTime minusSeconds(long var1);

    public native LocalTime minusNanos(long var1);

    @Override
    public native <R> R query(TemporalQuery<R> var1);

    @Override
    public native Temporal adjustInto(Temporal var1);

    @Override
    public native long until(Temporal var1, TemporalUnit var2);

    public native String format(DateTimeFormatter var1);

    public native LocalDateTime atDate(LocalDate var1);

    public native OffsetTime atOffset(ZoneOffset var1);

    public native int toSecondOfDay();

    public native long toNanoOfDay();

    @Override
    public native int compareTo(LocalTime var1);

    public native boolean isAfter(LocalTime var1);

    public native boolean isBefore(LocalTime var1);

    public native boolean equals(Object var1);

    public native int hashCode();

    public native String toString();
}

