/*
 * Decompiled with CFR 0.152.
 */
package java.time;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Period
implements ChronoPeriod,
Serializable {
    public static final Period ZERO = new Period(0, 0, 0);
    private final int years;
    private final int months;
    private final int days;

    private Period(int years, int months, int days) {
        this.years = years;
        this.months = months;
        this.days = days;
    }

    public static Period _of(int adjYears, int adjMonths, int adjDays) {
        if (adjYears == 0 && adjMonths == 0 && adjDays == 0) {
            return ZERO;
        }
        return new Period(adjYears, adjMonths, adjDays);
    }

    public static Period ofYears(int years) {
        return Period._of(years, 0, 0);
    }

    public static Period ofMonths(int months) {
        return Period._of(0, months, 0);
    }

    public static Period ofWeeks(int weeks) {
        return Period._of(0, 0, weeks * 7);
    }

    public static Period ofDays(int days) {
        return Period._of(0, 0, days);
    }

    public static Period of(int years, int months, int days) {
        return Period._of(years, months, days);
    }

    public static Period from(TemporalAmount amount) {
        return Period._of((int)amount.get(ChronoUnit.YEARS), (int)amount.get(ChronoUnit.MONTHS), (int)amount.get(ChronoUnit.DAYS));
    }

    public static Period parse(CharSequence text) {
        Pattern pattern = Pattern.compile("^(-?)P((-?[0-9]+)Y)?((-?[0-9]+)M)?((-?[0-9]+)D)?$");
        Matcher matcher = pattern.matcher(text);
        if (!matcher.matches()) {
            throw new DateTimeParseException("Text cannot be parsed to a Period", text, 0);
        }
        boolean globalNegate = Objects.equals(matcher.group(1), "-");
        String yearsStr = matcher.group(3);
        String monthsStr = matcher.group(5);
        String daysStr = matcher.group(7);
        int years = yearsStr != null ? Integer.parseInt(yearsStr) : 0;
        int months = monthsStr != null ? Integer.parseInt(monthsStr) : 0;
        int days = daysStr != null ? Integer.parseInt(daysStr) : 0;
        Period period = Period._of(years, months, days);
        return globalNegate ? period.negated() : period;
    }

    public static Period between(LocalDate startDateInclusive, LocalDate endDateExclusive) {
        long start = startDateInclusive.toEpochDay();
        long end = endDateExclusive.toEpochDay();
        return Period._of(0, 0, (int)(end - start)).normalized();
    }

    @Override
    public long get(TemporalUnit unit) {
        if (!(unit instanceof ChronoUnit)) {
            return 0L;
        }
        switch ((ChronoUnit)unit) {
            case DAYS: {
                return this.days;
            }
            case MONTHS: {
                return this.months;
            }
            case YEARS: {
                return this.years;
            }
        }
        return 0L;
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Arrays.asList(ChronoUnit.DAYS, ChronoUnit.MONTHS, ChronoUnit.YEARS);
    }

    @Override
    public IsoChronology getChronology() {
        return IsoChronology.INSTANCE;
    }

    private int getTotalDays() {
        return this.getYears() * 365 + this.getMonths() * 30 + this.getDays();
    }

    @Override
    public boolean isZero() {
        return this.getTotalDays() == 0;
    }

    @Override
    public boolean isNegative() {
        return this.getTotalDays() < 0;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Period withYears(int years) {
        return Period._of(years, this.months, this.days);
    }

    public Period withMonths(int months) {
        return Period._of(this.years, months, this.days);
    }

    public Period withDays(int days) {
        return Period._of(this.years, this.months, days);
    }

    private Period _plus(long yearsDelta, long monthsDelta, long daysDelta) {
        return Period._of((int)((long)this.years + yearsDelta), (int)((long)this.months + monthsDelta), (int)((long)this.days + daysDelta));
    }

    private Period _minus(long yearsDelta, long monthsDelta, long daysDelta) {
        return Period._of((int)((long)this.years - yearsDelta), (int)((long)this.months - monthsDelta), (int)((long)this.days - daysDelta));
    }

    @Override
    public Period plus(TemporalAmount delta) {
        return this._plus(0L, 0L, delta.get(ChronoUnit.DAYS));
    }

    public Period plusYears(long delta) {
        return this._plus(delta, 0L, 0L);
    }

    public Period plusMonths(long delta) {
        return this._plus(0L, delta, 0L);
    }

    public Period plusDays(long delta) {
        return this._plus(0L, 0L, delta);
    }

    @Override
    public Period minus(TemporalAmount delta) {
        return this._minus(0L, 0L, delta.get(ChronoUnit.DAYS));
    }

    public Period minusYears(long delta) {
        return this._minus(delta, 0L, 0L);
    }

    public Period minusMonths(long delta) {
        return this._minus(0L, delta, 0L);
    }

    public Period minusDays(long delta) {
        return this._minus(0L, 0L, delta);
    }

    @Override
    public Period multipliedBy(int scalar) {
        return Period._of(this.years * scalar, this.months * scalar, this.days * scalar);
    }

    @Override
    public Period negated() {
        return Period._of(-this.years, -this.months, -this.days);
    }

    @Override
    public Period normalized() {
        return this;
    }

    public long toTotalMonths() {
        return this.years / 12 + this.months + this.days * 30;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return temporal.plus(this.getTotalDays(), ChronoUnit.DAYS);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return temporal.plus(-this.getTotalDays(), ChronoUnit.DAYS);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return this.getTotalDays();
    }

    @Override
    public String toString() {
        if (this.isZero()) {
            return "P0D";
        }
        String out = "P";
        if (this.years != 0) {
            out = out + this.years + "Y";
        }
        if (this.months != 0) {
            out = out + this.months + "M";
        }
        if (this.days != 0) {
            out = out + this.days + "D";
        }
        return out;
    }
}

