/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ScheduledThreadPoolExecutor
extends ThreadPoolExecutor
implements ScheduledExecutorService {
    private Timer timer = new Timer("Scheduler-timer-");

    public ScheduledThreadPoolExecutor(int corePoolSize) {
        this(corePoolSize, null, null);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        this(corePoolSize, threadFactory, null);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        this(corePoolSize, null, handler);
    }

    public ScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, Integer.MAX_VALUE, 0L, TimeUnit.NANOSECONDS, new DelayedWorkQueue(), threadFactory, handler);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledFutureTask f = new ScheduledFutureTask(command);
        this.timer.schedule(f, unit.toMillis(delay));
        return f;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledFutureTask f = new ScheduledFutureTask(callable);
        this.timer.schedule(f, unit.toMillis(delay));
        return f;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        ScheduledFutureTask f = new ScheduledFutureTask(command);
        this.timer.scheduleAtFixedRate(f, unit.toMillis(initialDelay), unit.toMillis(period));
        return f;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledFutureTask f = new ScheduledFutureTask(command);
        this.timer.scheduleAtFixedRate(f, unit.toMillis(initialDelay), unit.toMillis(delay));
        return f;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, 50L, TimeUnit.MILLISECONDS);
    }

    private class ScheduledFutureTask<V>
    extends TimerTask
    implements ScheduledFuture<V> {
        Runnable runnable;
        Callable<V> callable;
        V res;
        boolean done = false;
        boolean cancelled = false;

        ScheduledFutureTask(Runnable r) {
            this.runnable = r;
        }

        ScheduledFutureTask(Callable c) {
            this.callable = c;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return super.cancel();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            if (this.callable == null) {
                return null;
            }
            while (this.res == null) {
                Thread.sleep(100L);
            }
            return this.res;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.callable == null) {
                return null;
            }
            for (long time = unit.toMillis(timeout); this.res == null && time > 0L; time -= 100L) {
                Thread.sleep(100L);
            }
            return this.res;
        }

        @Override
        public void run() {
            if (this.runnable != null) {
                ScheduledThreadPoolExecutor.this.execute(this.runnable);
            }
            if (this.callable != null) {
                ScheduledThreadPoolExecutor.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ScheduledFutureTask.this.res = ScheduledFutureTask.this.callable.call();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            this.done = true;
        }
    }

    private static class DelayedWorkQueue
    extends SynchronousQueue {
        private DelayedWorkQueue() {
        }
    }
}

