/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class Semaphore {
    private int permits;
    private final boolean fair;
    Queue<Thread> threadQueue = new LinkedList<Thread>();

    public Semaphore(int permits) {
        this(permits, false);
    }

    public Semaphore(int permits, boolean fair) {
        this.permits = permits;
        this.fair = fair;
    }

    public boolean isFair() {
        return this.fair;
    }

    protected void reducePermits(int reduction) {
        this.permits -= reduction;
    }

    public int drainPermits() {
        int permits = this.permits;
        try {
            this.acquire(permits);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return permits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(int permits) throws InterruptedException {
        while (true) {
            Semaphore semaphore = this;
            synchronized (semaphore) {
                if (this.permits >= permits) {
                    this.permits -= permits;
                    return;
                }
            }
            Thread currentThread = Thread.currentThread();
            this.threadQueue.add(currentThread);
            try {
                this.wait();
                continue;
            }
            finally {
                this.threadQueue.remove(currentThread);
                continue;
            }
            break;
        }
    }

    public void release(int permits) {
        this.permits += permits;
        this.notifyAll();
    }

    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    public void release() {
        this.release(1);
    }

    public void acquireUninterruptibly(int permits) {
        while (true) {
            try {
                this.acquire(permits);
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public native boolean tryAcquire(int var1, long var2, TimeUnit var4) throws InterruptedException;

    public void acquireUninterruptibly() {
        this.acquireUninterruptibly(1);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    public boolean tryAcquire(int permits) {
        while (true) {
            try {
                return this.tryAcquire(permits, 0L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public int availablePermits() {
        return this.permits;
    }

    public final boolean hasQueuedThreads() {
        return this.getQueueLength() > 0;
    }

    public final int getQueueLength() {
        return this.threadQueue.size();
    }

    protected Collection<Thread> getQueuedThreads() {
        return this.threadQueue;
    }

    public String toString() {
        return super.toString() + "[Permits = " + this.permits + "]";
    }
}

