/*
 * Decompiled with CFR 0.152.
 */
package com.jtransc.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\f\u00a8\u0006\u0015"}, d2={"Lcom/jtransc/io/FileBytes;", "", "()V", "copy", "", "from", "Ljava/io/File;", "to", "makeDirectories", "", "file", "read", "", "", "charset", "Ljava/nio/charset/Charset;", "is", "Ljava/io/InputStream;", "write", "string", "data", "jtransc-utils_main"})
public final class FileBytes {
    public static final FileBytes INSTANCE;

    public final boolean makeDirectories(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.mkdirs();
    }

    public final void copy(@NotNull File from, @NotNull File to) {
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        this.write(to, this.read(from));
    }

    @NotNull
    public final byte[] read(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.read(new FileInputStream(file));
    }

    @NotNull
    public final String read(@NotNull File file, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        byte[] byArray = this.read(file);
        return new String(byArray, charset);
    }

    public final void write(@NotNull File file, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(data);
        fout.close();
    }

    public final void write(@NotNull File file, @NotNull Charset charset, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        ByteBuffer bb = charset.encode(string);
        byte[] data = new byte[bb.remaining()];
        bb.get(data);
        this.write(file, data);
    }

    @NotNull
    public final byte[] read(@NotNull InputStream is) {
        Intrinsics.checkParameterIsNotNull((Object)is, (String)"is");
        byte[] data = new byte[is.available()];
        is.read(data);
        is.close();
        return data;
    }

    private FileBytes() {
        INSTANCE = this;
    }

    static {
        new FileBytes();
    }
}

